/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.mandelbrot;

import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.mandelbrot.MandelbrotJava;
import uk.ac.manchester.tornado.benchmarks.mandelbrot.MandelbrotTornado;

public class Benchmark
extends BenchmarkRunner {
    private int size;

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 2) {
            this.iterations = Integer.parseInt(args[0]);
            this.size = Integer.parseInt(args[1]);
        } else if (args.length == 1) {
            System.out.printf("Two arguments are needed: iterations size", new Object[0]);
        } else {
            this.iterations = 131;
            this.size = 512;
        }
    }

    @Override
    protected String getName() {
        return "mandelbrot";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d", this.getName(), this.iterations, this.size);
    }

    @Override
    protected String getConfigString() {
        return String.format("size=%d", this.size);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new MandelbrotJava(this.iterations, this.size);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new MandelbrotTornado(this.iterations, this.size);
    }
}

