/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.juliaset;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class JuliaSetTornado
extends BenchmarkDriver {
    private final int size;
    private final int iterations;
    private static FloatArray hue;
    private static FloatArray brightness;

    public JuliaSetTornado(int iterations, int size) {
        super(iterations);
        this.iterations = iterations;
        this.size = size;
    }

    @Override
    public void setUp() {
        hue = new FloatArray(this.size * this.size);
        brightness = new FloatArray(this.size * this.size);
        this.taskGraph = new TaskGraph("benchmark").task("juliaSet", GraphicsKernels::juliaSetTornado, (Object)this.size, (Object)hue, (Object)brightness).transferToHost(1, new Object[]{hue, brightness});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        hue = null;
        brightness = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        FloatArray hueSeq = new FloatArray(this.size * this.size);
        FloatArray brightnessSeq = new FloatArray(this.size * this.size);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        GraphicsKernels.juliaSetTornado(this.size, hueSeq, brightnessSeq);
        boolean isCorrect = true;
        float delta = 0.01f;
        for (int i = 0; i < hueSeq.getSize(); ++i) {
            if (Math.abs(hueSeq.get(i) - hue.get(i)) > delta) {
                isCorrect = false;
                break;
            }
            if (!(Math.abs(brightnessSeq.get(i) - brightness.get(i)) > delta)) continue;
            isCorrect = false;
            break;
        }
        return isCorrect;
    }

    @Override
    public TaskGraph getTaskGraph() {
        return this.taskGraph;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

