/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.juliaset;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class JuliaSetJava
extends BenchmarkDriver {
    private final int size;
    private final int iterations;
    private static FloatArray hue;
    private static FloatArray brightness;

    public JuliaSetJava(int iterations, int size) {
        super(iterations);
        this.iterations = iterations;
        this.size = size;
    }

    @Override
    public void setUp() {
        hue = new FloatArray(this.size * this.size);
        brightness = new FloatArray(this.size * this.size);
    }

    @Override
    public void tearDown() {
        hue = null;
        brightness = null;
        super.tearDown();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        GraphicsKernels.juliaSetTornado(this.size, hue, brightness);
    }
}

