/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.hilbert;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class JMHHilbert {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void hilbertJava(BenchmarkSetup state) {
        ComputeKernels.hilbertComputation(state.hilbertMatrix, state.size, state.size);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void hilbertTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executionPlan;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHHilbert.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.SECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        private int size = Integer.parseInt(System.getProperty("x", "4096"));
        private FloatArray hilbertMatrix;
        private TornadoExecutionPlan executionPlan;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.hilbertMatrix = new FloatArray(this.size * this.size);
            TaskGraph taskGraph = new TaskGraph("s0").task("t0", ComputeKernels::hilbertComputation, (Object)this.hilbertMatrix, (Object)this.size, (Object)this.size).transferToHost(1, new Object[]{this.hilbertMatrix});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executionPlan.withPreCompilation();
        }
    }
}

