/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.hilbert;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class HilbertTornado
extends BenchmarkDriver {
    private int size;
    private FloatArray hilbertMatrix;

    public HilbertTornado(int size, int iterations) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.hilbertMatrix = new FloatArray(this.size * this.size);
        this.taskGraph = new TaskGraph("benchmark").task("t0", ComputeKernels::hilbertComputation, (Object)this.hilbertMatrix, (Object)this.size, (Object)this.size).transferToHost(1, new Object[]{this.hilbertMatrix});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.hilbertMatrix = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        boolean val = true;
        FloatArray testData = new FloatArray(this.size * this.size);
        TaskGraph taskGraph1 = new TaskGraph("s0").task("t0", ComputeKernels::hilbertComputation, (Object)testData, (Object)this.size, (Object)this.size).transferToHost(1, new Object[]{testData});
        ImmutableTaskGraph immutableTaskGraph = taskGraph1.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executor.withDevice(device).execute();
        FloatArray seq = new FloatArray(this.size * this.size);
        ComputeKernels.hilbertComputation(seq, this.size, this.size);
        block0: for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (!(Math.abs(testData.get(i * this.size + j) - seq.get(i * this.size + j)) > 0.01f)) continue;
                val = false;
                continue block0;
            }
        }
        return val;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

