/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.euler;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class JMHEuler {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void eulerJava(BenchmarkSetup state) {
        ComputeKernels.euler(state.size, state.input, state.outputA, state.outputB, state.outputC, state.outputD, state.outputE);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void eulerTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHEuler.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        private int size = Integer.parseInt(System.getProperty("x", "128"));
        LongArray input;
        LongArray outputA;
        LongArray outputB;
        LongArray outputC;
        LongArray outputD;
        LongArray outputE;
        private TornadoExecutionPlan executor;

        private LongArray init(int size) {
            LongArray input = new LongArray(size);
            for (int i = 0; i < size; ++i) {
                input.set(i, (long)i * (long)i * (long)i * (long)i * (long)i);
            }
            return input;
        }

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.input = this.init(this.size);
            this.outputA = new LongArray(this.size);
            this.outputB = new LongArray(this.size);
            this.outputC = new LongArray(this.size);
            this.outputD = new LongArray(this.size);
            this.outputE = new LongArray(this.size);
            TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{this.input}).task("s0", ComputeKernels::euler, (Object)this.size, (Object)this.input, (Object)this.outputA, (Object)this.outputB, (Object)this.outputC, (Object)this.outputD, (Object)this.outputE).transferToHost(1, new Object[]{this.outputA, this.outputB, this.outputC, this.outputD, this.outputE});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

