/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.euler;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class EulerTornado
extends BenchmarkDriver {
    private int size;
    LongArray input;
    LongArray outputA;
    LongArray outputB;
    LongArray outputC;
    LongArray outputD;
    LongArray outputE;

    public EulerTornado(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    private LongArray init(int size) {
        LongArray input = new LongArray(size);
        for (int i = 0; i < size; ++i) {
            input.set(i, (long)i * (long)i * (long)i * (long)i * (long)i);
        }
        return input;
    }

    @Override
    public void setUp() {
        this.input = this.init(this.size);
        this.outputA = new LongArray(this.size);
        this.outputB = new LongArray(this.size);
        this.outputC = new LongArray(this.size);
        this.outputD = new LongArray(this.size);
        this.outputE = new LongArray(this.size);
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.input}).task("euler", ComputeKernels::euler, (Object)this.size, (Object)this.input, (Object)this.outputA, (Object)this.outputB, (Object)this.outputC, (Object)this.outputD, (Object)this.outputE).transferToHost(1, new Object[]{this.outputA, this.outputB, this.outputC, this.outputD, this.outputE});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.input = null;
        this.outputA = null;
        this.outputB = null;
        this.outputC = null;
        this.outputD = null;
        this.outputE = null;
        super.tearDown();
    }

    private void runSequential(int size, LongArray input, LongArray outputA, LongArray outputB, LongArray outputC, LongArray outputD, LongArray outputE) {
        ComputeKernels.euler(size, input, outputA, outputB, outputC, outputD, outputE);
        for (int i = 0; i < outputA.getSize(); ++i) {
            if (outputA.get(i) == 0L) continue;
            long a = outputA.get(i);
            long b = outputB.get(i);
            long c = outputC.get(i);
            long d = outputD.get(i);
            long e = outputE.get(i);
            System.out.println(a + "^5 + " + b + "^5 + " + c + "^5 + " + d + "^5 = " + e + "^5");
        }
    }

    private void runParallel(int size, LongArray input, LongArray outputA, LongArray outputB, LongArray outputC, LongArray outputD, LongArray outputE, TornadoDevice device) {
        TaskGraph graph = new TaskGraph("s0").task("s0", ComputeKernels::euler, (Object)size, (Object)input, (Object)outputA, (Object)outputB, (Object)outputC, (Object)outputD, (Object)outputE).transferToHost(1, new Object[]{outputA, outputB, outputC, outputD, outputE});
        ImmutableTaskGraph immutableTaskGraph = graph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        LongArray input = this.init(this.size);
        LongArray outputA = new LongArray(this.size);
        LongArray outputB = new LongArray(this.size);
        LongArray outputC = new LongArray(this.size);
        LongArray outputD = new LongArray(this.size);
        LongArray outputE = new LongArray(this.size);
        this.runSequential(this.size, input, outputA, outputB, outputC, outputD, outputE);
        LongArray outputAT = new LongArray(this.size);
        LongArray outputBT = new LongArray(this.size);
        LongArray outputCT = new LongArray(this.size);
        LongArray outputDT = new LongArray(this.size);
        LongArray outputET = new LongArray(this.size);
        this.runParallel(this.size, input, outputAT, outputBT, outputCT, outputDT, outputET, device);
        for (int i = 0; i < outputA.getSize(); ++i) {
            if (outputAT.get(i) != outputA.get(i)) {
                return false;
            }
            if (outputBT.get(i) != outputB.get(i)) {
                return false;
            }
            if (outputCT.get(i) != outputC.get(i)) {
                return false;
            }
            if (outputDT.get(i) != outputD.get(i)) {
                return false;
            }
            if (outputET.get(i) == outputE.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

