/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.euler;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class EulerJava
extends BenchmarkDriver {
    private int size;
    LongArray input;
    LongArray outputA;
    LongArray outputB;
    LongArray outputC;
    LongArray outputD;
    LongArray outputE;

    public EulerJava(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    private LongArray init(int size) {
        LongArray input = new LongArray(size);
        for (int i = 0; i < size; ++i) {
            input.set(i, (long)i * (long)i * (long)i * (long)i * (long)i);
        }
        return input;
    }

    @Override
    public void setUp() {
        this.input = this.init(this.size);
        this.outputA = new LongArray(this.size);
        this.outputB = new LongArray(this.size);
        this.outputC = new LongArray(this.size);
        this.outputD = new LongArray(this.size);
        this.outputE = new LongArray(this.size);
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        ComputeKernels.euler(this.size, this.input, this.outputA, this.outputB, this.outputC, this.outputD, this.outputE);
    }
}

