/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.euler;

import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.euler.EulerJava;
import uk.ac.manchester.tornado.benchmarks.euler.EulerTornado;

public class Benchmark
extends BenchmarkRunner {
    private int size;

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 2) {
            this.iterations = Integer.parseInt(args[0]);
            this.size = Integer.parseInt(args[1]);
        } else {
            this.iterations = 16;
            this.size = 128;
        }
    }

    @Override
    protected String getName() {
        return "euler";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d", this.getName(), this.iterations, this.size);
    }

    @Override
    protected String getConfigString() {
        return String.format("size=%d", this.size);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new EulerJava(this.iterations, this.size);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new EulerTornado(this.iterations, this.size);
    }
}

