/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dotvector;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class DotTornado
extends BenchmarkDriver {
    private final int numElements;
    private VectorFloat3 a;
    private VectorFloat3 b;
    private FloatArray c;

    public DotTornado(int iterations, int numElements) {
        super(iterations);
        this.numElements = numElements;
    }

    @Override
    public void setUp() {
        this.a = new VectorFloat3(this.numElements);
        this.b = new VectorFloat3(this.numElements);
        this.c = new FloatArray(this.numElements);
        Random r = new Random();
        for (int i = 0; i < this.numElements; ++i) {
            this.a.set(i, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
            this.b.set(i, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
        }
        this.taskGraph = new TaskGraph("benchmark");
        this.taskGraph.transferToDevice(1, new Object[]{this.a, this.b});
        this.taskGraph.task("dotVector", GraphicsKernels::dotVector, (Object)this.a, (Object)this.b, (Object)this.c);
        this.taskGraph.transferToHost(1, new Object[]{this.c});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.a = null;
        this.b = null;
        this.c = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        FloatArray result = new FloatArray(this.numElements);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        GraphicsKernels.dotVector(this.a, this.b, result);
        float ulp = TornadoMath.findULPDistance((FloatArray)result, (FloatArray)this.c);
        return Float.compare(ulp, MAX_ULP) <= 0;
    }
}

