/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dotvector;

import java.util.Random;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class DotJava
extends BenchmarkDriver {
    private final int numElements;
    private VectorFloat3 a;
    private VectorFloat3 b;
    private FloatArray c;

    public DotJava(int iterations, int numElements) {
        super(iterations);
        this.numElements = numElements;
    }

    @Override
    public void setUp() {
        this.a = new VectorFloat3(this.numElements);
        this.b = new VectorFloat3(this.numElements);
        this.c = new FloatArray(this.numElements);
        Random r = new Random();
        for (int i = 0; i < this.numElements; ++i) {
            this.a.set(i, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
            this.b.set(i, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
        }
    }

    @Override
    public void tearDown() {
        this.a = null;
        this.b = null;
        this.c = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        GraphicsKernels.dotVector(this.a, this.b, this.c);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

