/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dotimage;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class JMHDotImage {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void dotImageJava(BenchmarkSetup state) {
        GraphicsKernels.dotImage(state.a, state.b, state.c);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void dotImageTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHDotImage.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        int numElementsX = Integer.parseInt(System.getProperty("x", "2048"));
        int numElementsY = Integer.parseInt(System.getProperty("x", "2048"));
        private ImageFloat3 a;
        private ImageFloat3 b;
        private ImageFloat c;
        TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.a = new ImageFloat3(this.numElementsX, this.numElementsY);
            this.b = new ImageFloat3(this.numElementsX, this.numElementsY);
            this.c = new ImageFloat(this.numElementsX, this.numElementsY);
            Random r = new Random();
            for (int i = 0; i < this.numElementsX; ++i) {
                for (int j = 0; j < this.numElementsY; ++j) {
                    this.a.set(i, j, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
                    this.b.set(i, j, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
                }
            }
            TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.a, this.b}).task("dotVector", GraphicsKernels::dotImage, (Object)this.a, (Object)this.b, (Object)this.c).transferToHost(1, new Object[]{this.c});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

