/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dotimage;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class DotTornado
extends BenchmarkDriver {
    private final int numElementsX;
    private final int numElementsY;
    private ImageFloat3 a;
    private ImageFloat3 b;
    private ImageFloat c;

    public DotTornado(int iterations, int numElementsX, int numElementsY) {
        super(iterations);
        this.numElementsX = numElementsX;
        this.numElementsY = numElementsY;
    }

    @Override
    public void setUp() {
        this.a = new ImageFloat3(this.numElementsX, this.numElementsY);
        this.b = new ImageFloat3(this.numElementsX, this.numElementsY);
        this.c = new ImageFloat(this.numElementsX, this.numElementsY);
        Random r = new Random();
        for (int i = 0; i < this.numElementsX; ++i) {
            for (int j = 0; j < this.numElementsY; ++j) {
                this.a.set(i, j, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
                this.b.set(i, j, new Float3(r.nextFloat(), r.nextFloat(), r.nextFloat()));
            }
        }
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.a, this.b}).task("dotVector", GraphicsKernels::dotImage, (Object)this.a, (Object)this.b, (Object)this.c).transferToHost(1, new Object[]{this.c});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.a = null;
        this.b = null;
        this.c = null;
        this.executionResult.getProfilerResult().dumpProfiles();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        ImageFloat result = new ImageFloat(this.numElementsX, this.numElementsX);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        GraphicsKernels.dotImage(this.a, this.b, result);
        float maxULP = 0.0f;
        for (int i = 0; i < this.c.Y(); ++i) {
            for (int j = 0; j < this.c.X(); ++j) {
                float ulp = FloatOps.findMaxULP((float)this.c.get(j, i), (float)result.get(j, i));
                if (!(ulp > maxULP)) continue;
                maxULP = ulp;
            }
        }
        return Float.compare(maxULP, MAX_ULP) <= 0;
    }
}

