/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dotimage;

import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.dotimage.DotJava;
import uk.ac.manchester.tornado.benchmarks.dotimage.DotTornado;

public class Benchmark
extends BenchmarkRunner {
    private int width;
    private int height;

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 3) {
            this.iterations = Integer.parseInt(args[0]);
            this.width = Integer.parseInt(args[1]);
            this.height = Integer.parseInt(args[1]);
        } else {
            this.iterations = 100;
            this.width = 2048;
            this.height = 2048;
        }
    }

    @Override
    protected String getName() {
        return "dot-image";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d-%d", this.getName(), this.iterations, this.width, this.height);
    }

    @Override
    protected String getConfigString() {
        return String.format("width=%d, height=%d", this.width, this.height);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new DotJava(this.iterations, this.width, this.height);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new DotTornado(this.iterations, this.width, this.height);
    }
}

