/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dgemm;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.LinearAlgebraArrays;

public class DgemmTornado
extends BenchmarkDriver {
    private final int m;
    private final int n;
    private DoubleArray a;
    private DoubleArray b;
    private DoubleArray c;

    public DgemmTornado(int iterations, int m, int n) {
        super(iterations);
        this.m = m;
        this.n = n;
    }

    @Override
    public void setUp() {
        int i;
        this.a = new DoubleArray(this.m * this.n);
        this.b = new DoubleArray(this.m * this.n);
        this.c = new DoubleArray(this.m * this.n);
        Random random = new Random();
        for (i = 0; i < this.m; ++i) {
            this.a.set(i * (this.m + 1), 1.0);
        }
        for (i = 0; i < this.m * this.n; ++i) {
            this.b.set(i, (double)random.nextFloat());
        }
        this.taskGraph = new TaskGraph("benchmark");
        this.taskGraph.transferToDevice(1, new Object[]{this.a, this.b}).task("dgemm", LinearAlgebraArrays::dgemm, (Object)this.m, (Object)this.n, (Object)this.n, (Object)this.a, (Object)this.b, (Object)this.c).transferToHost(1, new Object[]{this.c});
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.taskGraph.snapshot()});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.a = null;
        this.b = null;
        this.c = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        DoubleArray result = new DoubleArray(this.m * this.n);
        this.runBenchmark(device);
        this.executionPlan.clearProfiles();
        LinearAlgebraArrays.dgemm(this.m, this.n, this.m, this.a, this.b, result);
        double ulp = TornadoMath.findULPDistance((DoubleArray)this.c, (DoubleArray)result);
        return ulp < (double)MAX_ULP;
    }
}

