/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dft;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class JMHDFT {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void dftJava(BenchmarkSetup state) {
        ComputeKernels.computeDFT(state.inReal, state.inImag, state.outReal, state.outImag);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void dftTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHDFT.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        private int size = Integer.parseInt(System.getProperty("x", "8192"));
        private DoubleArray inReal;
        private DoubleArray inImag;
        private DoubleArray outReal;
        private DoubleArray outImag;
        private TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.inReal = new DoubleArray(this.size);
            this.inImag = new DoubleArray(this.size);
            this.outReal = new DoubleArray(this.size);
            this.outImag = new DoubleArray(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.inReal.set(i, 1.0 / (double)(i + 2));
                this.inImag.set(i, 1.0 / (double)(i + 2));
            }
            TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.inReal, this.inImag}).task("t0", ComputeKernels::computeDFT, (Object)this.inReal, (Object)this.inImag, (Object)this.outReal, (Object)this.outImag).transferToHost(1, new Object[]{this.outReal, this.outImag});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

