/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dft;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class DFTTornado
extends BenchmarkDriver {
    private int size;
    private FloatArray inReal;
    private FloatArray inImag;
    private FloatArray outReal;
    private FloatArray outImag;

    public DFTTornado(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    private void initData() {
        this.inReal = new FloatArray(this.size);
        this.inImag = new FloatArray(this.size);
        this.outReal = new FloatArray(this.size);
        this.outImag = new FloatArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.inReal.set(i, (float)(1 / (i + 2)));
            this.inImag.set(i, (float)(1 / (i + 2)));
        }
    }

    @Override
    public void setUp() {
        this.initData();
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.inReal, this.inImag}).task("t0", ComputeKernels::computeDFT, (Object)this.inReal, (Object)this.inImag, (Object)this.outReal, (Object)this.outImag).transferToHost(1, new Object[]{this.outReal, this.outImag});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        boolean validation = true;
        FloatArray outRealTor = new FloatArray(this.size);
        FloatArray outImagTor = new FloatArray(this.size);
        this.executionPlan.withDevice(device).withPreCompilation().execute();
        ComputeKernels.computeDFT(this.inReal, this.inImag, outRealTor, outImagTor);
        this.executionPlan.clearProfiles();
        for (int i = 0; i < this.size; ++i) {
            if ((double)TornadoMath.abs((float)(outImagTor.get(i) - this.outImag.get(i))) > 0.01) {
                validation = false;
                break;
            }
            if (!((double)TornadoMath.abs((float)(this.outReal.get(i) - outRealTor.get(i))) > 0.01)) continue;
            validation = false;
            break;
        }
        System.out.print("Is correct?: " + validation + "\n");
        return validation;
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.outImag = null;
        this.outReal = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

