/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.dft;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class DFTJava
extends BenchmarkDriver {
    private int size;
    private DoubleArray inReal;
    private DoubleArray inImag;
    private DoubleArray outReal;
    private DoubleArray outImag;

    public DFTJava(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.inReal = new DoubleArray(this.size);
        this.inImag = new DoubleArray(this.size);
        this.outReal = new DoubleArray(this.size);
        this.outImag = new DoubleArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.inReal.set(i, 1.0 / (double)(i + 2));
            this.inImag.set(i, 1.0 / (double)(i + 2));
        }
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    @Override
    public void tearDown() {
        this.outImag = null;
        this.outReal = null;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        ComputeKernels.computeDFT(this.inReal, this.inImag, this.outReal, this.outImag);
    }
}

