/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.convolveimage;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkUtils;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class ConvolveImageTornado
extends BenchmarkDriver {
    private final int imageSizeX;
    private final int imageSizeY;
    private final int filterSize;
    private ImageFloat input;
    private ImageFloat output;
    private ImageFloat filter;

    public ConvolveImageTornado(int iterations, int imageSizeX, int imageSizeY, int filterSize) {
        super(iterations);
        this.imageSizeX = imageSizeX;
        this.imageSizeY = imageSizeY;
        this.filterSize = filterSize;
    }

    @Override
    public void setUp() {
        this.input = new ImageFloat(this.imageSizeX, this.imageSizeY);
        this.output = new ImageFloat(this.imageSizeX, this.imageSizeY);
        this.filter = new ImageFloat(this.filterSize, this.filterSize);
        BenchmarkUtils.createImage(this.input);
        BenchmarkUtils.createFilter(this.filter);
        this.taskGraph = new TaskGraph("benchmark");
        this.taskGraph.transferToDevice(1, new Object[]{this.input, this.filter});
        this.taskGraph.task("convolveImage", GraphicsKernels::convolveImage, (Object)this.input, (Object)this.filter, (Object)this.output);
        this.taskGraph.transferToHost(1, new Object[]{this.output});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.input = null;
        this.output = null;
        this.filter = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        ImageFloat result = new ImageFloat(this.imageSizeX, this.imageSizeY);
        this.runBenchmark(device);
        GraphicsKernels.convolveImage(this.input, this.filter, result);
        float maxULP = 0.0f;
        for (int y = 0; y < this.output.Y(); ++y) {
            for (int x = 0; x < this.output.X(); ++x) {
                float ulp = FloatOps.findMaxULP((float)this.output.get(x, y), (float)result.get(x, y));
                if (!(ulp > maxULP)) continue;
                maxULP = ulp;
            }
        }
        return Float.compare(maxULP, MAX_ULP) <= 0;
    }
}

