/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.convolveimage;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkUtils;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class ConvolveImageJava
extends BenchmarkDriver {
    private final int imageSizeX;
    private final int imageSizeY;
    private final int filterSize;
    private ImageFloat input;
    private ImageFloat output;
    private ImageFloat filter;

    public ConvolveImageJava(int iterations, int imageSizeX, int imageSizeY, int filterSize) {
        super(iterations);
        this.imageSizeX = imageSizeX;
        this.imageSizeY = imageSizeY;
        this.filterSize = filterSize;
    }

    @Override
    public void setUp() {
        this.input = new ImageFloat(this.imageSizeX, this.imageSizeY);
        this.output = new ImageFloat(this.imageSizeX, this.imageSizeY);
        this.filter = new ImageFloat(this.filterSize, this.filterSize);
        BenchmarkUtils.createImage(this.input);
        BenchmarkUtils.createFilter(this.filter);
    }

    @Override
    public void tearDown() {
        this.input = null;
        this.output = null;
        this.filter = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        GraphicsKernels.convolveImage(this.input, this.filter, this.output);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

