/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.convolvearray;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkUtils;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class JMHConvolveArray {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void convolveImageArrayJava(BenchmarkSetup state) {
        GraphicsKernels.convolveImageArray(state.input, state.filter, state.output, state.imageSizeX, state.imageSizeY, state.filterSize, state.filterSize);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void convolveImageArrayTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHConvolveArray.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        int imageSizeX = Integer.parseInt(System.getProperty("x", "2048"));
        int imageSizeY = Integer.parseInt(System.getProperty("y", "2048"));
        int filterSize = Integer.parseInt(System.getProperty("z", "5"));
        FloatArray input;
        FloatArray output;
        FloatArray filter;
        TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.input = new FloatArray(this.imageSizeX * this.imageSizeY);
            this.output = new FloatArray(this.imageSizeX * this.imageSizeY);
            this.filter = new FloatArray(this.filterSize * this.filterSize);
            BenchmarkUtils.createImage(this.input, this.imageSizeX, this.imageSizeY);
            BenchmarkUtils.createFilter(this.filter, this.filterSize, this.filterSize);
            TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.input, this.filter}).task("convolveImageArray", GraphicsKernels::convolveImageArray, (Object)this.input, (Object)this.filter, (Object)this.output, (Object)this.imageSizeX, (Object)this.imageSizeY, (Object)this.filterSize, (Object)this.filterSize).transferToHost(1, new Object[]{this.output});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withDefaultScheduler().withPreCompilation();
        }
    }
}

