/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.convolvearray;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkUtils;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class ConvolveImageArrayTornado
extends BenchmarkDriver {
    private final int imageSizeX;
    private final int imageSizeY;
    private final int filterSize;
    private FloatArray input;
    private FloatArray output;
    private FloatArray filter;

    public ConvolveImageArrayTornado(int iterations, int imageSizeX, int imageSizeY, int filterSize) {
        super(iterations);
        this.imageSizeX = imageSizeX;
        this.imageSizeY = imageSizeY;
        this.filterSize = filterSize;
    }

    @Override
    public void setUp() {
        this.input = new FloatArray(this.imageSizeX * this.imageSizeY);
        this.output = new FloatArray(this.imageSizeX * this.imageSizeY);
        this.filter = new FloatArray(this.filterSize * this.filterSize);
        BenchmarkUtils.createImage(this.input, this.imageSizeX, this.imageSizeY);
        BenchmarkUtils.createFilter(this.filter, this.filterSize, this.filterSize);
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.input, this.filter}).task("convolveImageArray", GraphicsKernels::convolveImageArray, (Object)this.input, (Object)this.filter, (Object)this.output, (Object)this.imageSizeX, (Object)this.imageSizeY, (Object)this.filterSize, (Object)this.filterSize).transferToHost(1, new Object[]{this.output});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.input = null;
        this.output = null;
        this.filter = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        FloatArray result = new FloatArray(this.imageSizeX * this.imageSizeY);
        this.runBenchmark(device);
        GraphicsKernels.convolveImageArray(this.input, this.filter, result, this.imageSizeX, this.imageSizeY, this.filterSize, this.filterSize);
        float maxULP = 0.0f;
        for (int i = 0; i < this.output.getSize(); ++i) {
            float ulp = FloatOps.findMaxULP((float)result.get(i), (float)this.output.get(i));
            if (!(ulp > maxULP)) continue;
            maxULP = ulp;
        }
        return Float.compare(maxULP, MAX_ULP) <= 0;
    }
}

