/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.convolvearray;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkUtils;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class ConvolveImageArrayJava
extends BenchmarkDriver {
    private final int imageSizeX;
    private final int imageSizeY;
    private final int filterSize;
    private FloatArray input;
    private FloatArray output;
    private FloatArray filter;

    public ConvolveImageArrayJava(int iterations, int imageSizeX, int imageSizeY, int filterSize) {
        super(iterations);
        this.imageSizeX = imageSizeX;
        this.imageSizeY = imageSizeY;
        this.filterSize = filterSize;
    }

    @Override
    public void setUp() {
        this.input = new FloatArray(this.imageSizeX * this.imageSizeY);
        this.output = new FloatArray(this.imageSizeX * this.imageSizeY);
        this.filter = new FloatArray(this.filterSize * this.filterSize);
        BenchmarkUtils.createImage(this.input, this.imageSizeX, this.imageSizeY);
        BenchmarkUtils.createFilter(this.filter, this.filterSize, this.filterSize);
    }

    @Override
    public void tearDown() {
        this.input = null;
        this.output = null;
        this.filter = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        GraphicsKernels.convolveImageArray(this.input, this.filter, this.output, this.imageSizeX, this.imageSizeY, this.filterSize, this.filterSize);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

