/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.convolvearray;

import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.BenchmarkRunner;
import uk.ac.manchester.tornado.benchmarks.convolvearray.ConvolveImageArrayJava;
import uk.ac.manchester.tornado.benchmarks.convolvearray.ConvolveImageArrayTornado;

public class Benchmark
extends BenchmarkRunner {
    private int width;
    private int height;
    private int filtersize;

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 4) {
            this.iterations = Integer.parseInt(args[0]);
            this.width = Integer.parseInt(args[1]);
            this.height = Integer.parseInt(args[2]);
            this.filtersize = Integer.parseInt(args[3]);
        } else {
            this.iterations = 100;
            this.width = 2048;
            this.height = 2048;
            this.filtersize = 5;
        }
    }

    @Override
    protected String getName() {
        return "convolve-array";
    }

    @Override
    protected String getIdString() {
        return String.format("%s-%d-%d-%d-%d", this.getName(), this.iterations, this.width, this.height, this.filtersize);
    }

    @Override
    protected String getConfigString() {
        return String.format("width=%d, height=%d, filtersize=%d", this.width, this.height, this.filtersize);
    }

    @Override
    protected BenchmarkDriver getJavaDriver() {
        return new ConvolveImageArrayJava(this.iterations, this.width, this.height, this.filtersize);
    }

    @Override
    protected BenchmarkDriver getTornadoDriver() {
        return new ConvolveImageArrayTornado(this.iterations, this.width, this.height, this.filtersize);
    }
}

