/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.blurFilter;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class JMHBlurFilter {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void blurFilterJava(BenchmarkSetup state) {
        ComputeKernels.channelConvolution(state.redChannel, state.redFilter, state.size, state.size, state.filter, 31);
        ComputeKernels.channelConvolution(state.greenChannel, state.greenFilter, state.size, state.size, state.filter, 31);
        ComputeKernels.channelConvolution(state.blueChannel, state.blueFilter, state.size, state.size, state.filter, 31);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void blurFilterTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHBlurFilter.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        int size = Integer.parseInt(System.getProperty("x", "512"));
        public static final int FILTER_WIDTH = 31;
        IntArray redChannel;
        IntArray greenChannel;
        IntArray blueChannel;
        IntArray alphaChannel;
        IntArray redFilter;
        IntArray greenFilter;
        IntArray blueFilter;
        FloatArray filter;
        TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            int w = this.size;
            int h = this.size;
            this.redChannel = new IntArray(w * h);
            this.greenChannel = new IntArray(w * h);
            this.blueChannel = new IntArray(w * h);
            this.alphaChannel = new IntArray(w * h);
            this.greenFilter = new IntArray(w * h);
            this.redFilter = new IntArray(w * h);
            this.blueFilter = new IntArray(w * h);
            this.filter = new FloatArray(w * h);
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    this.filter.set(i * h + j, 0.0010405828f);
                }
            }
            Random r = new Random();
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    int rgb = r.nextInt(255);
                    this.alphaChannel.set(i * h + j, rgb >> 24 & 0xFF);
                    this.redChannel.set(i * h + j, rgb >> 16 & 0xFF);
                    this.greenChannel.set(i * h + j, rgb >> 8 & 0xFF);
                    this.blueChannel.set(i * h + j, rgb & 0xFF);
                }
            }
            TaskGraph taskGraph = new TaskGraph("blur").transferToDevice(1, new Object[]{this.redChannel, this.greenChannel, this.blueChannel, this.filter}).task("red", ComputeKernels::channelConvolution, (Object)this.redChannel, (Object)this.redFilter, (Object)w, (Object)h, (Object)this.filter, (Object)31).task("green", ComputeKernels::channelConvolution, (Object)this.greenChannel, (Object)this.greenFilter, (Object)w, (Object)h, (Object)this.filter, (Object)31).task("blue", ComputeKernels::channelConvolution, (Object)this.blueChannel, (Object)this.blueFilter, (Object)w, (Object)h, (Object)this.filter, (Object)31).transferToHost(1, new Object[]{this.redFilter, this.greenFilter, this.blueFilter});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withDefaultScheduler().withPreCompilation();
        }
    }
}

