/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.blurFilter;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class BlurFilterTornado
extends BenchmarkDriver {
    private int size;
    public static final int FILTER_WIDTH = 31;
    IntArray redChannel;
    IntArray greenChannel;
    IntArray blueChannel;
    IntArray alphaChannel;
    IntArray redFilter;
    IntArray greenFilter;
    IntArray blueFilter;
    FloatArray filter;

    public BlurFilterTornado(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        int w = this.size;
        int h = this.size;
        this.redChannel = new IntArray(w * h);
        this.greenChannel = new IntArray(w * h);
        this.blueChannel = new IntArray(w * h);
        this.alphaChannel = new IntArray(w * h);
        this.greenFilter = new IntArray(w * h);
        this.redFilter = new IntArray(w * h);
        this.blueFilter = new IntArray(w * h);
        this.filter = new FloatArray(w * h);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                this.filter.set(i * h + j, 0.0010405828f);
            }
        }
        Random r = new Random();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int rgb = r.nextInt(255);
                this.alphaChannel.set(i * h + j, rgb >> 24 & 0xFF);
                this.redChannel.set(i * h + j, rgb >> 16 & 0xFF);
                this.greenChannel.set(i * h + j, rgb >> 8 & 0xFF);
                this.blueChannel.set(i * h + j, rgb & 0xFF);
            }
        }
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.redChannel, this.greenChannel, this.blueChannel, this.filter}).task("blurRed", ComputeKernels::channelConvolution, (Object)this.redChannel, (Object)this.redFilter, (Object)w, (Object)h, (Object)this.filter, (Object)31).task("blurGreen", ComputeKernels::channelConvolution, (Object)this.greenChannel, (Object)this.greenFilter, (Object)w, (Object)h, (Object)this.filter, (Object)31).task("blurBlue", ComputeKernels::channelConvolution, (Object)this.blueChannel, (Object)this.blueFilter, (Object)w, (Object)h, (Object)this.filter, (Object)31).transferToHost(1, new Object[]{this.redFilter, this.greenFilter, this.blueFilter});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withDefaultScheduler().withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.redChannel = null;
        this.greenChannel = null;
        this.blueChannel = null;
        this.alphaChannel = null;
        this.greenFilter = null;
        this.redFilter = null;
        this.blueFilter = null;
        super.tearDown();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        boolean valid = true;
        int w = this.size;
        int h = this.size;
        IntArray redChannel = new IntArray(w * h);
        IntArray greenChannel = new IntArray(w * h);
        IntArray blueChannel = new IntArray(w * h);
        IntArray alphaChannel = new IntArray(w * h);
        IntArray greenFilter = new IntArray(w * h);
        IntArray redFilter = new IntArray(w * h);
        IntArray blueFilter = new IntArray(w * h);
        IntArray greenFilterSeq = new IntArray(w * h);
        IntArray redFilterSeq = new IntArray(w * h);
        IntArray blueFilterSeq = new IntArray(w * h);
        FloatArray filter = new FloatArray(w * h);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                filter.set(i * h + j, 0.0010405828f);
            }
        }
        Random r = new Random();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int rgb = r.nextInt(255);
                alphaChannel.set(i * h + j, rgb >> 24 & 0xFF);
                redChannel.set(i * h + j, rgb >> 16 & 0xFF);
                greenChannel.set(i * h + j, rgb >> 8 & 0xFF);
                blueChannel.set(i * h + j, rgb & 0xFF);
            }
        }
        TaskGraph parallelFilter = new TaskGraph("blur").transferToDevice(1, new Object[]{redChannel, greenChannel, blueChannel, filter}).task("red", ComputeKernels::channelConvolution, (Object)redChannel, (Object)redFilter, (Object)w, (Object)h, (Object)filter, (Object)31).task("green", ComputeKernels::channelConvolution, (Object)greenChannel, (Object)greenFilter, (Object)w, (Object)h, (Object)filter, (Object)31).task("blue", ComputeKernels::channelConvolution, (Object)blueChannel, (Object)blueFilter, (Object)w, (Object)h, (Object)filter, (Object)31).transferToHost(1, new Object[]{redFilter, greenFilter, blueFilter});
        ImmutableTaskGraph immutableTaskGraph1 = parallelFilter.snapshot();
        TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph1});
        executor.withDevice(device).withDefaultScheduler().execute();
        ComputeKernels.channelConvolution(redChannel, redFilterSeq, this.size, this.size, filter, 31);
        ComputeKernels.channelConvolution(greenChannel, greenFilterSeq, this.size, this.size, filter, 31);
        ComputeKernels.channelConvolution(blueChannel, blueFilterSeq, this.size, this.size, filter, 31);
        for (int i = 0; i < redFilter.getSize(); ++i) {
            if (redFilter.get(i) != redFilterSeq.get(i)) {
                valid = false;
                break;
            }
            if (greenFilter.get(i) != greenFilterSeq.get(i)) {
                valid = false;
                break;
            }
            if (blueFilter.get(i) == blueFilterSeq.get(i)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

