/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.blurFilter;

import java.util.Random;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class BlurFilterJava
extends BenchmarkDriver {
    private int size;
    public static final int FILTER_WIDTH = 31;
    IntArray redChannel;
    IntArray greenChannel;
    IntArray blueChannel;
    IntArray alphaChannel;
    IntArray redFilter;
    IntArray greenFilter;
    IntArray blueFilter;
    FloatArray filter;

    public BlurFilterJava(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        int w = this.size;
        int h = this.size;
        this.redChannel = new IntArray(w * h);
        this.greenChannel = new IntArray(w * h);
        this.blueChannel = new IntArray(w * h);
        this.alphaChannel = new IntArray(w * h);
        this.greenFilter = new IntArray(w * h);
        this.redFilter = new IntArray(w * h);
        this.blueFilter = new IntArray(w * h);
        this.filter = new FloatArray(w * h);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                this.filter.set(i * h + j, 0.0010405828f);
            }
        }
        Random r = new Random();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                int rgb = r.nextInt(255);
                this.alphaChannel.set(i * h + j, rgb >> 24 & 0xFF);
                this.redChannel.set(i * h + j, rgb >> 16 & 0xFF);
                this.greenChannel.set(i * h + j, rgb >> 8 & 0xFF);
                this.blueChannel.set(i * h + j, rgb & 0xFF);
            }
        }
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        ComputeKernels.channelConvolution(this.redChannel, this.redFilter, this.size, this.size, this.filter, 31);
        ComputeKernels.channelConvolution(this.greenChannel, this.greenFilter, this.size, this.size, this.filter, 31);
        ComputeKernels.channelConvolution(this.blueChannel, this.blueFilter, this.size, this.size, this.filter, 31);
    }
}

