/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.blackscholes;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class JMHBlackScholes {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void blachcholesJava(BenchmarkSetup state) {
        ComputeKernels.blackscholes(state.randArray, state.put, state.call);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @Warmup(iterations=2, time=30, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=5, time=30, timeUnit=TimeUnit.SECONDS)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void blachcholesTornado(BenchmarkSetup state, Blackhole blackhole) {
        TornadoExecutionPlan executor = state.executor;
        executor.execute();
        blackhole.consume((Object)executor);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JMHBlackScholes.class.getName() + ".*").mode(Mode.AverageTime).timeUnit(TimeUnit.NANOSECONDS).warmupTime(TimeValue.seconds((long)60L)).warmupIterations(2).measurementTime(TimeValue.seconds((long)30L)).measurementIterations(5).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkSetup {
        int size = Integer.parseInt(System.getProperty("x", "8192"));
        FloatArray randArray;
        FloatArray call;
        FloatArray put;
        TaskGraph taskGraph;
        TornadoExecutionPlan executor;

        @Setup(value=Level.Trial)
        public void doSetup() {
            this.randArray = new FloatArray(this.size);
            this.call = new FloatArray(this.size);
            this.put = new FloatArray(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.randArray.set(i, (float)i * 1.0f / (float)this.size);
            }
            this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.randArray}).task("t0", ComputeKernels::blackscholes, (Object)this.randArray, (Object)this.put, (Object)this.call).transferToHost(1, new Object[]{this.put, this.call});
            ImmutableTaskGraph immutableTaskGraph = this.taskGraph.snapshot();
            this.executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            this.executor.withPreCompilation();
        }
    }
}

