/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.blackscholes;

import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class BlackScholesTornado
extends BenchmarkDriver {
    private final int size;
    private FloatArray randArray;
    private FloatArray call;
    private FloatArray put;

    public BlackScholesTornado(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.randArray = new FloatArray(this.size);
        this.call = new FloatArray(this.size);
        this.put = new FloatArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.randArray.set(i, (float)i * 1.0f / (float)this.size);
        }
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.randArray}).task("t0", ComputeKernels::blackscholes, (Object)this.randArray, (Object)this.put, (Object)this.call).transferToHost(1, new Object[]{this.put, this.call});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
    }

    @Override
    public void tearDown() {
        if (this.executionResult != null) {
            this.executionResult.getProfilerResult().dumpProfiles();
        }
        this.randArray = null;
        this.call = null;
        this.put = null;
        if (this.executionPlan != null) {
            this.executionPlan.resetDevice();
        }
        super.tearDown();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        boolean val = true;
        FloatArray randArraySeq = new FloatArray(this.size);
        FloatArray callTor = new FloatArray(this.size);
        FloatArray putTor = new FloatArray(this.size);
        FloatArray callSeq = new FloatArray(this.size);
        FloatArray putSeq = new FloatArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            randArraySeq.set(i, this.randArray.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{randArraySeq}).task("t0", ComputeKernels::blackscholes, (Object)randArraySeq, (Object)putTor, (Object)callTor).transferToHost(1, new Object[]{putTor, callTor});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withDevice(device).execute();
        }
        catch (TornadoExecutionPlanException e) {
            e.printStackTrace();
            throw new TornadoRuntimeException((Exception)((Object)e));
        }
        ComputeKernels.blackscholes(randArraySeq, putSeq, callSeq);
        for (int i = 0; i < this.size; ++i) {
            if ((double)TornadoMath.abs((float)(putTor.get(i) - putSeq.get(i))) > 0.01) {
                System.out.printf("Number validation: " + putTor.get(i) + " vs " + putSeq.get(i) + "\n", new Object[0]);
                val = false;
                break;
            }
            if (!((double)TornadoMath.abs((float)(callTor.get(i) - callSeq.get(i))) > 0.01)) continue;
            System.out.printf("Number validation: " + callTor.get(i) + " vs " + callSeq.get(i) + "\n", new Object[0]);
            val = false;
            break;
        }
        System.out.printf("Number validation: " + val + "\n", new Object[0]);
        return val;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }
}

