/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.blackscholes;

import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.ComputeKernels;

public class BlackScholesJava
extends BenchmarkDriver {
    private final int size;
    private FloatArray randArray;
    private FloatArray call;
    private FloatArray put;

    public BlackScholesJava(int iterations, int size) {
        super(iterations);
        this.size = size;
    }

    @Override
    public void setUp() {
        this.randArray = new FloatArray(this.size);
        this.call = new FloatArray(this.size);
        this.put = new FloatArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.randArray.set(i, (float)i * 1.0f / (float)this.size);
        }
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        ComputeKernels.blackscholes(this.randArray, this.call, this.put);
    }
}

