/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.addImage;

import java.util.Random;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.images.ImageFloat4;
import uk.ac.manchester.tornado.api.types.utils.FloatOps;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class AddTornado
extends BenchmarkDriver {
    private final int numElementsX;
    private final int numElementsY;
    private ImageFloat4 a;
    private ImageFloat4 b;
    private ImageFloat4 c;

    public AddTornado(int iterations, int numElementsX, int numElementsY) {
        super(iterations);
        this.numElementsX = numElementsX;
        this.numElementsY = numElementsY;
    }

    private void initData() {
        this.a = new ImageFloat4(this.numElementsX, this.numElementsY);
        this.b = new ImageFloat4(this.numElementsX, this.numElementsY);
        this.c = new ImageFloat4(this.numElementsX, this.numElementsY);
        Random r = new Random();
        for (int j = 0; j < this.numElementsY; ++j) {
            for (int i = 0; i < this.numElementsX; ++i) {
                this.a.set(i, j, new Float4(r.nextFloat(), r.nextFloat(), r.nextFloat(), r.nextFloat()));
                this.b.set(i, j, new Float4(r.nextFloat(), r.nextFloat(), r.nextFloat(), r.nextFloat()));
            }
        }
    }

    @Override
    public void setUp() {
        this.initData();
        this.taskGraph = new TaskGraph("benchmark").transferToDevice(1, new Object[]{this.a, this.b}).task("addImage", GraphicsKernels::addImage, (Object)this.a, (Object)this.b, (Object)this.c).transferToHost(1, new Object[]{this.c});
        this.immutableTaskGraph = this.taskGraph.snapshot();
        this.executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{this.immutableTaskGraph});
        this.executionPlan.withPreCompilation();
    }

    @Override
    public void tearDown() {
        this.executionResult.getProfilerResult().dumpProfiles();
        this.a = null;
        this.b = null;
        this.c = null;
        this.executionPlan.resetDevice();
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        this.executionResult = this.executionPlan.withDevice(device).execute();
    }

    @Override
    public boolean validate(TornadoDevice device) {
        ImageFloat4 result = new ImageFloat4(this.numElementsX, this.numElementsY);
        this.runBenchmark(device);
        GraphicsKernels.addImage(this.a, this.b, result);
        float maxULP = 0.0f;
        for (int i = 0; i < this.c.Y(); ++i) {
            for (int j = 0; j < this.c.X(); ++j) {
                float ulp = FloatOps.findMaxULP((Float4)this.c.get(j, i), (Float4)result.get(j, i));
                if (!(ulp > maxULP)) continue;
                maxULP = ulp;
            }
        }
        return Float.compare(maxULP, MAX_ULP) <= 0;
    }
}

