/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks.addImage;

import java.util.Random;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.types.images.ImageFloat4;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.GraphicsKernels;

public class AddJava
extends BenchmarkDriver {
    private final int numElementsX;
    private final int numElementsY;
    ImageFloat4 a;
    ImageFloat4 b;
    ImageFloat4 c;

    public AddJava(int iterations, int numElementsX, int numElementsY) {
        super(iterations);
        this.numElementsX = numElementsX;
        this.numElementsY = numElementsY;
    }

    @Override
    public void setUp() {
        this.a = new ImageFloat4(this.numElementsX, this.numElementsY);
        this.b = new ImageFloat4(this.numElementsX, this.numElementsY);
        this.c = new ImageFloat4(this.numElementsX, this.numElementsY);
        Random r = new Random(73L);
        for (int j = 0; j < this.numElementsY; ++j) {
            for (int i = 0; i < this.numElementsX; ++i) {
                this.a.set(i, j, new Float4(r.nextFloat(), r.nextFloat(), r.nextFloat(), r.nextFloat()));
                this.b.set(i, j, new Float4(r.nextFloat(), r.nextFloat(), r.nextFloat(), r.nextFloat()));
            }
        }
    }

    @Override
    public void tearDown() {
        this.a = null;
        this.b = null;
        this.c = null;
        super.tearDown();
    }

    @Override
    public void runBenchmark(TornadoDevice device) {
        GraphicsKernels.addImage(this.a, this.b, this.c);
    }

    @Override
    public void barrier() {
    }

    @Override
    public boolean validate(TornadoDevice device) {
        return true;
    }

    public void printSummary() {
        System.out.printf("id=java-serial, elapsed=%f, per iteration=%f\n", this.getElapsed(), this.getElapsedPerIteration());
    }
}

