/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks;

import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;

public class LinearAlgebraArrays {
    public static void saxpy(float alpha, FloatArray x, FloatArray y) {
        for (int i = 0; i < y.getSize(); ++i) {
            y.set(i, y.get(i) + alpha * x.get(i));
        }
    }

    public static void sgemv(int M, int N, FloatArray A, FloatArray X, FloatArray Y) {
        for (int i = 0; i < M; ++i) {
            float y0 = 0.0f;
            for (int j = 0; j < N; ++j) {
                y0 += A.get(j + i * N) * X.get(j);
            }
            Y.set(i, y0);
        }
    }

    public static void sgemm(int M, int N, int K, FloatArray A, FloatArray B, FloatArray C) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < K; ++k) {
                    sum += A.get(i * N + k) * B.get(k * N + j);
                }
                C.set(i * N + j, sum);
            }
        }
    }

    public static void dgemm(int M, int N, int K, DoubleArray A, DoubleArray B, DoubleArray C) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                double sum = 0.0;
                for (int k = 0; k < K; ++k) {
                    sum += A.get(i * N + k) * B.get(k * N + j);
                }
                C.set(i * N + j, sum);
            }
        }
    }

    public static void spmv(FloatArray val, IntArray cols, IntArray rowDelimiters, FloatArray vec, int dim, FloatArray out) {
        for (int i = 0; i < dim; ++i) {
            float t = 0.0f;
            for (int j = rowDelimiters.get(i); j < rowDelimiters.get(i + 1); ++j) {
                int col = cols.get(j);
                t += val.get(j) * vec.get(col);
            }
            out.set(i, t);
        }
    }
}

