/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks;

import java.util.stream.IntStream;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat4;
import uk.ac.manchester.tornado.api.types.matrix.Matrix4x4Float;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;

public final class GraphicsKernels {
    private static final int MAX_ITERATIONS = 1000;
    private static final float ZOOM = 1.0f;
    private static final float CX = -0.7f;
    private static final float CY = 0.27015f;
    private static final float MOVE_X = 0.0f;
    private static final float MOVE_Y = 0.0f;

    public static void rotateVector(VectorFloat3 output, Matrix4x4Float m, VectorFloat3 input) {
        for (int i = 0; i < output.getLength(); ++i) {
            Float3 x = input.get(i);
            Float3 y = TornadoMath.rotate((Matrix4x4Float)m, (Float3)x);
            output.set(i, y);
        }
    }

    public static void dotVector(VectorFloat3 A, VectorFloat3 B, FloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            Float3 a = A.get(i);
            Float3 b = B.get(i);
            c.set(i, Float3.dot((Float3)a, (Float3)b));
        }
    }

    public static void rotateImage(ImageFloat3 output, Matrix4x4Float m, ImageFloat3 input) {
        for (int i = 0; i < output.Y(); ++i) {
            for (int j = 0; j < output.X(); ++j) {
                Float3 x = input.get(j, i);
                Float3 y = TornadoMath.rotate((Matrix4x4Float)m, (Float3)x);
                output.set(j, i, y);
            }
        }
    }

    public static void rotateImageStreams(ImageFloat3 output, Matrix4x4Float m, ImageFloat3 input) {
        IntStream.range(0, output.X() * output.Y()).parallel().forEach(index -> {
            int j = index % output.X();
            int i = index / output.X();
            Float3 x = input.get(j, i);
            Float3 y = TornadoMath.rotate((Matrix4x4Float)m, (Float3)x);
            output.set(j, i, y);
        });
    }

    public static void dotImage(ImageFloat3 A, ImageFloat3 B, ImageFloat C) {
        for (int i = 0; i < C.Y(); ++i) {
            for (int j = 0; j < C.X(); ++j) {
                Float3 a = A.get(j, i);
                Float3 b = B.get(j, i);
                C.set(j, i, Float3.dot((Float3)a, (Float3)b));
            }
        }
    }

    public static void addImage(ImageFloat4 a, ImageFloat4 b, ImageFloat4 c) {
        for (int i = 0; i < c.Y(); ++i) {
            for (int j = 0; j < c.X(); ++j) {
                c.set(j, i, Float4.add((Float4)a.get(j, i), (Float4)b.get(j, i)));
            }
        }
    }

    public static void convolveImageArray(FloatArray input, FloatArray filter, FloatArray output, int iW, int iH, int fW, int fH) {
        int filterX2 = fW / 2;
        int filterY2 = fH / 2;
        for (int y = 0; y < iH; ++y) {
            for (int x = 0; x < iW; ++x) {
                float sum = 0.0f;
                for (int v = 0; v < fH; ++v) {
                    for (int u = 0; u < fW; ++u) {
                        if (y - filterY2 + v < 0 || y + v >= iH || x - filterX2 + u < 0 || x + u >= iW) continue;
                        sum += filter.get(v * fW + u) * input.get((y - filterY2 + v) * iW + (x - filterX2 + u));
                    }
                }
                output.set(y * iW + x, sum);
            }
        }
    }

    public static void convolveImage(ImageFloat input, ImageFloat filter, ImageFloat output) {
        int filterX2 = filter.X() / 2;
        int filterY2 = filter.Y() / 2;
        for (int y = 0; y < output.Y(); ++y) {
            for (int x = 0; x < output.X(); ++x) {
                float sum = 0.0f;
                for (int v = 0; v < filter.Y(); ++v) {
                    for (int u = 0; u < filter.X(); ++u) {
                        if (y - filterY2 + v < 0 || y + v >= output.Y() || x - filterX2 + u < 0 || x + u >= output.X()) continue;
                        sum += filter.get(u, v) * input.get(x - filterX2 + u, y - filterY2 + v);
                    }
                }
                output.set(x, y, sum);
            }
        }
    }

    public static void convolveImageStreams(ImageFloat input, ImageFloat filter, ImageFloat output) {
        int filterX2 = filter.X() / 2;
        int filterY2 = filter.Y() / 2;
        IntStream.range(0, output.X() * output.Y()).parallel().forEach(index -> {
            int x = index % output.X();
            int y = index / output.X();
            float sum = 0.0f;
            for (int v = 0; v < filter.Y(); ++v) {
                for (int u = 0; u < filter.X(); ++u) {
                    if (y - filterY2 + v < 0 || y + v >= output.Y() || x - filterX2 + u < 0 || x + u >= output.X()) continue;
                    sum += filter.get(u, v) * input.get(x - filterX2 + u, y - filterY2 + v);
                }
            }
            output.set(x, y, sum);
        });
    }

    public static void juliaSetTornado(int size, FloatArray hue, FloatArray brightness) {
        for (int ix = 0; ix < size; ++ix) {
            for (int jx = 0; jx < size; ++jx) {
                float k;
                float zx = 1.5f * (float)(ix - size / 2) / (0.5f * (float)size) + 0.0f;
                float zy = (float)(jx - size / 2) / (0.5f * (float)size) + 0.0f;
                for (k = 1000.0f; zx * zx + zy * zy < 4.0f && k > 0.0f; k -= 1.0f) {
                    float tmp = zx * zx - zy * zy + -0.7f;
                    zy = 2.0f * zx * zy + 0.27015f;
                    zx = tmp;
                }
                hue.set(ix * size + jx, 1000.0f / k);
                brightness.set(ix * size + jx, k > 0.0f ? 1.0f : 0.0f);
            }
        }
    }
}

