/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks;

import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.api.types.images.ImageByte3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.vectors.Byte3;

public class ComputeKernels {
    public static final float S_LOWER_LIMIT = 10.0f;
    public static final float S_UPPER_LIMIT = 100.0f;
    public static final float K_LOWER_LIMIT = 10.0f;
    public static final float K_UPPER_LIMIT = 100.0f;
    public static final float T_LOWER_LIMIT = 1.0f;
    public static final float T_UPPER_LIMIT = 10.0f;
    public static final float R_LOWER_LIMIT = 0.01f;
    public static final float R_UPPER_LIMIT = 0.05f;
    public static final float SIGMA_LOWER_LIMIT = 0.01f;
    public static final float SIGMA_UPPER_LIMIT = 0.1f;

    public static void monteCarlo(FloatArray result, int size) {
        int total = size;
        int iter = 25000;
        for (int idx = 0; idx < total; ++idx) {
            long seed = idx;
            float sum = 0.0f;
            for (int j = 0; j < 25000; ++j) {
                seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
                seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
                float x = (float)(seed & 0xFFFFFFFL) / 2.6843546E8f;
                seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
                float y = (float)((seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) & 0xFFFFFFFL) / 2.6843546E8f;
                float dist = TornadoMath.sqrt((float)(x * x + y * y));
                if (!(dist <= 1.0f)) continue;
                sum += 1.0f;
            }
            result.set(idx, (sum *= 4.0f) / 25000.0f);
        }
    }

    public static void nBody(int numBodies, FloatArray refPos, FloatArray refVel, float delT, float espSqr) {
        for (int i = 0; i < numBodies; ++i) {
            int body = 4 * i;
            float[] acc = new float[]{0.0f, 0.0f, 0.0f};
            for (int j = 0; j < numBodies; ++j) {
                float[] r = new float[3];
                int index = 4 * j;
                float distSqr = 0.0f;
                for (int k = 0; k < 3; ++k) {
                    r[k] = refPos.get(index + k) - refPos.get(body + k);
                    distSqr += r[k] * r[k];
                }
                float invDist = 1.0f / TornadoMath.sqrt((float)(distSqr + espSqr));
                float invDistCube = invDist * invDist * invDist;
                float s = refPos.get(index + 3) * invDistCube;
                for (int k = 0; k < 3; ++k) {
                    int n = k;
                    acc[n] = acc[n] + s * r[k];
                }
            }
            for (int k = 0; k < 3; ++k) {
                refPos.set(body + k, refPos.get(body + k) + refPos.get(body + k) * delT + 0.5f * acc[k] * delT * delT);
                refVel.set(body + k, refPos.get(body + k) + acc[k] * delT);
            }
        }
    }

    static float phi(float X) {
        float c1 = 0.31938154f;
        float c2 = -0.35656378f;
        float c3 = 1.7814779f;
        float c4 = -1.8212559f;
        float c5 = 1.3302745f;
        float zero = 0.0f;
        float one = 1.0f;
        float two = 2.0f;
        float temp4 = 0.2316419f;
        float oneBySqrt2pi = 0.3989423f;
        float absX = Math.abs(X);
        float t = 1.0f / (1.0f + 0.2316419f * absX);
        float y = 1.0f - 0.3989423f * TornadoMath.exp((float)(-X * X / 2.0f)) * t * (0.31938154f + t * (-0.35656378f + t * (1.7814779f + t * (-1.8212559f + t * 1.3302745f))));
        return X < 0.0f ? 1.0f - y : y;
    }

    public static void blackscholes(FloatArray randArray, FloatArray put, FloatArray call) {
        for (int gid = 0; gid < call.getSize(); ++gid) {
            float two = 2.0f;
            float inRand = randArray.get(gid);
            float S = 10.0f * inRand + 100.0f * (1.0f - inRand);
            float K = 10.0f * inRand + 100.0f * (1.0f - inRand);
            float T = 1.0f * inRand + 10.0f * (1.0f - inRand);
            float R = 0.01f * inRand + 0.05f * (1.0f - inRand);
            float sigmaVal = 0.01f * inRand + 0.1f * (1.0f - inRand);
            float sigmaSqrtT = sigmaVal * TornadoMath.sqrt((float)T);
            float d1 = (TornadoMath.log((float)(S / K)) + (R + sigmaVal * sigmaVal / 2.0f) * T) / sigmaSqrtT;
            float d2 = d1 - sigmaSqrtT;
            float KexpMinusRT = K * TornadoMath.exp((float)(-R * T));
            float phiD1 = ComputeKernels.phi(d1);
            float phiD2 = ComputeKernels.phi(d2);
            call.set(gid, S * phiD1 - KexpMinusRT * phiD2);
            phiD1 = ComputeKernels.phi(-d1);
            phiD2 = ComputeKernels.phi(-d2);
            put.set(gid, KexpMinusRT * phiD2 - S * phiD1);
        }
    }

    public static void computeDFT(DoubleArray inreal, DoubleArray inimag, DoubleArray outreal, DoubleArray outimag) {
        int n = inreal.getSize();
        for (int k = 0; k < n; ++k) {
            float sumReal = 0.0f;
            float simImag = 0.0f;
            for (int t = 0; t < n; ++t) {
                double angle = Math.PI * 2 * (double)t * (double)k / (double)n;
                sumReal = (float)((double)sumReal + (inreal.get(t) * Math.cos(angle) + inimag.get(t) * Math.sin(angle)));
                simImag = (float)((double)simImag + (-inreal.get(t) * Math.sin(angle) + inimag.get(t) * Math.cos(angle)));
            }
            outreal.set(k, (double)sumReal);
            outimag.set(k, (double)simImag);
        }
    }

    public static void computeDFT(FloatArray inreal, FloatArray inimag, FloatArray outreal, FloatArray outimag) {
        int n = inreal.getSize();
        for (int k = 0; k < n; ++k) {
            float sumReal = 0.0f;
            float simImag = 0.0f;
            for (int t = 0; t < n; ++t) {
                float angle = 2.0f * TornadoMath.floatPI() * (float)t * (float)k / (float)n;
                sumReal += inreal.get(t) * TornadoMath.cos((float)angle) + inimag.get(t) * TornadoMath.sin((float)angle);
                simImag += -inreal.get(t) * TornadoMath.sin((float)angle) + inimag.get(t) * TornadoMath.cos((float)angle);
            }
            outreal.set(k, sumReal);
            outimag.set(k, simImag);
        }
    }

    public static void mandelbrot(int size, ShortArray output) {
        int iterations = 10000;
        float space = 2.0f / (float)size;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                float Zr = 0.0f;
                float Zi = 0.0f;
                float Cr = (float)(1 * j) * space - 1.5f;
                float Ci = (float)(1 * i) * space - 1.0f;
                float ZrN = 0.0f;
                float ZiN = 0.0f;
                int y = 0;
                for (int ii = 0; ii < 10000; ++ii) {
                    if (ZiN + ZrN <= 4.0f) {
                        Zi = 2.0f * Zr * Zi + Ci;
                        Zr = 1.0f * ZrN - ZiN + Cr;
                        ZiN = Zi * Zi;
                        ZrN = Zr * Zr;
                        ++y;
                        continue;
                    }
                    ii = 10000;
                }
                short r = (short)(y * 255 / 10000);
                output.set(i * size + j, r);
            }
        }
    }

    public static void hilbertComputation(FloatArray output, int rows, int cols) {
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                output.set(i * rows + j, 1.0f / (float)(i + 1 + (j + 1) - 1));
            }
        }
    }

    public static void channelConvolution(IntArray rgbChannel, IntArray channelBlurred, int numRows, int numCols, FloatArray filter, int filterWidth) {
        assert (filterWidth % 2 == 1);
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numCols; ++c) {
                float result = 0.0f;
                for (int filter_r = -filterWidth / 2; filter_r <= filterWidth / 2; ++filter_r) {
                    for (int filter_c = -filterWidth / 2; filter_c <= filterWidth / 2; ++filter_c) {
                        int image_r = Math.min(Math.max(r + filter_r, 0), numRows - 1);
                        int image_c = Math.min(Math.max(c + filter_c, 0), numCols - 1);
                        float image_value = rgbChannel.get(image_r * numCols + image_c);
                        float filter_value = filter.get((filter_r + filterWidth / 2) * filterWidth + filter_c + filterWidth / 2);
                        result += image_value * filter_value;
                    }
                }
                channelBlurred.set(r * numCols + c, result > 255.0f ? 255 : (int)result);
            }
        }
    }

    public static void renderTrack(ImageByte3 output, ImageFloat3 input) {
        for (int y = 0; y < input.Y(); ++y) {
            for (int x = 0; x < input.X(); ++x) {
                Byte3 pixel = null;
                int result = (int)input.get(x, y).getS2();
                switch (result) {
                    case 1: {
                        pixel = new Byte3(-128, -128, -128);
                        break;
                    }
                    case -1: {
                        pixel = new Byte3(0, 0, 0);
                        break;
                    }
                    case -2: {
                        pixel = new Byte3(-1, 0, 0);
                        break;
                    }
                    case -3: {
                        pixel = new Byte3(0, -1, 0);
                        break;
                    }
                    case -4: {
                        pixel = new Byte3(0, 0, -1);
                        break;
                    }
                    case -5: {
                        pixel = new Byte3(-1, -1, 0);
                        break;
                    }
                    default: {
                        pixel = new Byte3(-1, -128, -128);
                    }
                }
                output.set(x, y, pixel);
            }
        }
    }

    public static void euler(int size, LongArray five, LongArray outputA, LongArray outputB, LongArray outputC, LongArray outputD, LongArray outputE) {
        for (int e = 1; e < five.getSize(); ++e) {
            long e5 = five.get(e);
            for (int a = 1; a < five.getSize(); ++a) {
                long a5 = five.get(a);
                for (int b = a; b < size; ++b) {
                    long b5 = five.get(b);
                    for (int c = b; c < size; ++c) {
                        long c5 = five.get(c);
                        for (int d = c; d < size; ++d) {
                            long d5 = five.get(d);
                            if (a5 + b5 + c5 + d5 != e5) continue;
                            outputA.set(e, (long)a);
                            outputB.set(e, (long)b);
                            outputC.set(e, (long)c);
                            outputD.set(e, (long)d);
                            outputE.set(e, (long)e);
                        }
                    }
                }
            }
        }
    }
}

