/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks;

import java.util.Random;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;

public final class BenchmarkUtils {
    public static void createFilter(FloatArray filter, int width, int height) {
        int y;
        int x;
        float filterSum = 0.0f;
        Random rand = new Random();
        for (x = 0; x < height; ++x) {
            for (y = 0; y < width; ++y) {
                float f = rand.nextFloat();
                filterSum += f;
                filter.set(y * width + x, f);
            }
        }
        for (x = 0; x < height; ++x) {
            for (y = 0; y < width; ++y) {
                filter.set(y * width + x, (filter.get(y * width) + (float)x) / filterSum);
            }
        }
    }

    public static void createFilter(ImageFloat filter) {
        BenchmarkUtils.createFilter(filter.getArray(), filter.X(), filter.Y());
    }

    public static void createImage(FloatArray image, int width, int height) {
        Random rand = new Random();
        rand.setSeed(7L);
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                image.set(y * width + x, (float)rand.nextInt(256));
            }
        }
    }

    public static void createImage(ImageFloat image) {
        BenchmarkUtils.createImage(image.getArray(), image.X(), image.Y());
    }
}

