/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.benchmarks.BenchmarkDriver;
import uk.ac.manchester.tornado.benchmarks.convolvearray.Benchmark;

public abstract class BenchmarkRunner {
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    private static final boolean SKIP_TORNADOVM = Boolean.parseBoolean(System.getProperty("tornado.benchmarks.skiptornadovm", "FALSE"));
    private static final boolean SKIP_SERIAL = Boolean.parseBoolean(System.getProperty("tornado.benchmarks.skipserial", "FALSE"));
    private static final boolean SKIP_STREAMS = Boolean.parseBoolean(System.getProperty("tornado.benchmarks.skipstreams", "TRUE"));
    private static final String STORE_OUTPUT_TO_FILE = System.getProperty("tornado.benchmarks.store.output.to.file", "");
    protected int iterations;

    protected abstract String getName();

    protected abstract String getIdString();

    protected abstract String getConfigString();

    protected abstract BenchmarkDriver getJavaDriver();

    protected abstract BenchmarkDriver getTornadoDriver();

    protected BenchmarkDriver getStreamsDriver() {
        return null;
    }

    private static boolean isProfilerEnabled() {
        return TornadoRuntimeProvider.isProfilerEnabled();
    }

    private static boolean isPowerMonitoringEnabled() {
        return TornadoRuntimeProvider.isPowerMonitoringEnabled();
    }

    public void run() {
        double refFirstIteration;
        double refElapsedMedian;
        double refElapsed;
        String id = this.getIdString();
        if (!BenchmarkRunner.isProfilerEnabled() && !SKIP_SERIAL) {
            StringBuilder stringBuilder = new StringBuilder();
            BenchmarkDriver referenceTest = this.getJavaDriver();
            if (BenchmarkRunner.isPowerMonitoringEnabled()) {
                referenceTest.benchmarkWithEnergy(id, null, false);
            } else {
                referenceTest.benchmark(null, false);
            }
            stringBuilder.append("Performance: bm=" + id + ", id=java-reference, " + referenceTest.getPreciseSummary() + "\n");
            if (BenchmarkRunner.isPowerMonitoringEnabled()) {
                stringBuilder.append("Energy: bm=" + id + ", id=java-reference, " + referenceTest.getEnergySummary() + "\n");
            }
            refElapsed = referenceTest.getAverage();
            refElapsedMedian = referenceTest.getMedian();
            refFirstIteration = referenceTest.getFirstIteration();
            BenchmarkDriver streamsTest = this.getStreamsDriver();
            if (streamsTest != null && !SKIP_STREAMS) {
                if (BenchmarkRunner.isPowerMonitoringEnabled()) {
                    streamsTest.benchmarkWithEnergy(id, null, false);
                } else {
                    streamsTest.benchmark(null, false);
                }
                stringBuilder.append("Performance: bm=" + id + ", id=java-streams, " + streamsTest.getPreciseSummary() + "\n");
                if (BenchmarkRunner.isPowerMonitoringEnabled()) {
                    stringBuilder.append("Energy: bm=" + id + ", id=java-streams, " + streamsTest.getEnergySummary() + "\n");
                }
            }
            if (STORE_OUTPUT_TO_FILE.isEmpty()) {
                System.out.printf(stringBuilder.toString(), new Object[0]);
            } else {
                this.redirectOutputToFile(stringBuilder.toString());
            }
        } else {
            refElapsed = -1.0;
            refElapsedMedian = -1.0;
            refFirstIteration = -1.0;
        }
        if (!SKIP_TORNADOVM) {
            String selectedDevices = TornadoRuntimeProvider.getProperty((String)"devices");
            if (selectedDevices == null || selectedDevices.isEmpty()) {
                this.runBenchmarkAllDevices(id, refElapsed, refElapsedMedian, refFirstIteration);
            } else {
                this.bechmarkForSelectedDevice(id, selectedDevices, refElapsed, refElapsedMedian, refFirstIteration);
            }
        }
    }

    private void redirectOutputToFile(String output) {
        try (FileWriter writer = new FileWriter(STORE_OUTPUT_TO_FILE, true);){
            writer.append(output);
            writer.append("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void runBenchmarkAllDevices(String id, double refElapsed, double refElapsedMedian, double refFirstIteration) {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<Integer, Set<Integer>> blacklistedDevices = new HashMap<Integer, Set<Integer>>();
        this.findBlacklisted(blacklistedDevices, "tornado.blacklist.devices");
        int numDrivers = TornadoRuntimeProvider.getTornadoRuntime().getNumBackends();
        for (int driverIndex = 0; driverIndex < numDrivers; ++driverIndex) {
            TornadoBackend driver = TornadoRuntimeProvider.getTornadoRuntime().getBackend(driverIndex);
            int numDevices = driver.getNumDevices();
            for (int deviceIndex = 0; deviceIndex < numDevices; ++deviceIndex) {
                Set setIgnoredDevices;
                if (blacklistedDevices.containsKey(driverIndex) && (setIgnoredDevices = (Set)blacklistedDevices.get(driverIndex)).contains(deviceIndex)) continue;
                TornadoDevice tornadoDevice = driver.getDevice(deviceIndex);
                TornadoRuntimeProvider.setProperty((String)"benchmark.device", (String)(driverIndex + ":" + deviceIndex));
                BenchmarkDriver benchmarkDriver = this.getTornadoDriver();
                try {
                    if (BenchmarkRunner.isPowerMonitoringEnabled()) {
                        benchmarkDriver.benchmarkWithEnergy(id, tornadoDevice, BenchmarkRunner.isProfilerEnabled());
                    } else {
                        benchmarkDriver.benchmark(tornadoDevice, BenchmarkRunner.isProfilerEnabled());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!BenchmarkRunner.isProfilerEnabled()) {
                    stringBuilder.append("Performance: bm=" + id + ", device=" + driverIndex + ":" + deviceIndex + ", " + benchmarkDriver.getPreciseSummary() + ", speedupAvg=" + refElapsed / benchmarkDriver.getAverage() + ", speedupMedian=" + refElapsedMedian / benchmarkDriver.getMedian() + ", speedupFirstIteration=" + refFirstIteration / benchmarkDriver.getFirstIteration() + ", CV=" + benchmarkDriver.getCV() + ", deviceName=" + String.valueOf(driver.getDevice(deviceIndex)) + "\n");
                } else {
                    stringBuilder.append("Performance: bm=" + id + ", id=" + driverIndex + ":" + deviceIndex + ", kernelMin=" + benchmarkDriver.getBestKernelTime() + ", kernelAvg=" + benchmarkDriver.getAverageKernelTime() + ", copyInAvg=" + benchmarkDriver.getAverageCopyInTime() + ", copyOutAvg=" + benchmarkDriver.getAverageCopyOutTime() + ", deviceName=" + String.valueOf(driver.getDevice(deviceIndex)) + "\n");
                }
                if (BenchmarkRunner.isPowerMonitoringEnabled()) {
                    stringBuilder.append("Energy: bm=" + id + ", id=" + driverIndex + ":" + deviceIndex + ", " + benchmarkDriver.getEnergySummary() + "\n");
                }
                if (STORE_OUTPUT_TO_FILE.isEmpty()) {
                    System.out.printf(stringBuilder.toString(), new Object[0]);
                    continue;
                }
                this.redirectOutputToFile(stringBuilder.toString());
            }
        }
    }

    private void bechmarkForSelectedDevice(String id, String selectedDevices, double refElapsed, double refElapsedMedian, double refFirstIteration) {
        String[] devices;
        StringBuilder stringBuilder = new StringBuilder();
        for (String device : devices = selectedDevices.split(",")) {
            String[] stringIndex = device.split(":");
            int driverIndex = Integer.parseInt(stringIndex[0]);
            int deviceIndex = Integer.parseInt(stringIndex[1]);
            BenchmarkDriver deviceTest = this.getTornadoDriver();
            TornadoBackend driver = TornadoRuntimeProvider.getTornadoRuntime().getBackend(driverIndex);
            TornadoDevice tornadoDevice = driver.getDevice(deviceIndex);
            if (BenchmarkRunner.isPowerMonitoringEnabled()) {
                deviceTest.benchmarkWithEnergy(id, tornadoDevice, BenchmarkRunner.isProfilerEnabled());
            } else {
                deviceTest.benchmark(tornadoDevice, BenchmarkRunner.isProfilerEnabled());
            }
            stringBuilder.append("Performance: bm=" + id + ", device=" + driverIndex + ":" + deviceIndex + ", " + deviceTest.getPreciseSummary() + ", speedupAvg=" + refElapsed / deviceTest.getAverage() + ", speedupMedian=" + refElapsedMedian / deviceTest.getMedian() + ", speedupFirstIteration=" + refFirstIteration / deviceTest.getFirstIteration() + ", CV=" + deviceTest.getCV() + ", deviceName=" + String.valueOf(driver.getDevice(deviceIndex)) + "\n");
            if (STORE_OUTPUT_TO_FILE.isEmpty()) {
                System.out.printf(stringBuilder.toString(), new Object[0]);
                continue;
            }
            this.redirectOutputToFile(stringBuilder.toString());
        }
    }

    private void findBlacklisted(Map<Integer, Set<Integer>> blacklist, String property) {
        String[] tuple2BackendDevice;
        String values = System.getProperty(property, "");
        if (values.isEmpty()) {
            return;
        }
        for (String t2 : tuple2BackendDevice = values.split(",")) {
            String[] deviceIdentifier = t2.split(":");
            int backendIndex = Integer.parseInt(deviceIdentifier[0]);
            int deviceIndex = Integer.parseInt(deviceIdentifier[1]);
            Set<Integer> set = blacklist.containsKey(backendIndex) ? blacklist.get(backendIndex) : new HashSet<Integer>();
            set.add(deviceIndex);
            blacklist.put(backendIndex, set);
        }
    }

    public abstract void parseArgs(String[] var1);

    private static BenchmarkRunner getBenchMarkInstance(String benchmark) {
        return switch (benchmark = benchmark.toLowerCase()) {
            case "addimage" -> new uk.ac.manchester.tornado.benchmarks.addImage.Benchmark();
            case "blackscholes" -> new uk.ac.manchester.tornado.benchmarks.blackscholes.Benchmark();
            case "blurfilter" -> new uk.ac.manchester.tornado.benchmarks.blurFilter.Benchmark();
            case "convolvearray" -> new Benchmark();
            case "convolveimage" -> new uk.ac.manchester.tornado.benchmarks.convolveimage.Benchmark();
            case "dft" -> new uk.ac.manchester.tornado.benchmarks.dft.Benchmark();
            case "dgemm" -> new uk.ac.manchester.tornado.benchmarks.dgemm.Benchmark();
            case "dotimage" -> new uk.ac.manchester.tornado.benchmarks.dotimage.Benchmark();
            case "dorvector" -> new uk.ac.manchester.tornado.benchmarks.dotvector.Benchmark();
            case "euler" -> new uk.ac.manchester.tornado.benchmarks.euler.Benchmark();
            case "hilbert" -> new uk.ac.manchester.tornado.benchmarks.hilbert.Benchmark();
            case "juliaset" -> new uk.ac.manchester.tornado.benchmarks.juliaset.Benchmark();
            case "mandelbrot" -> new uk.ac.manchester.tornado.benchmarks.mandelbrot.Benchmark();
            case "montecarlo" -> new uk.ac.manchester.tornado.benchmarks.montecarlo.Benchmark();
            case "nbody" -> new uk.ac.manchester.tornado.benchmarks.nbody.Benchmark();
            case "rendertrack" -> new uk.ac.manchester.tornado.benchmarks.renderTrack.Benchmark();
            case "rotateimage" -> new uk.ac.manchester.tornado.benchmarks.rotateimage.Benchmark();
            case "rotatevector" -> new uk.ac.manchester.tornado.benchmarks.rotatevector.Benchmark();
            case "saxpy" -> new uk.ac.manchester.tornado.benchmarks.saxpy.Benchmark();
            case "sgemm" -> new uk.ac.manchester.tornado.benchmarks.sgemm.Benchmark();
            case "spmv" -> new uk.ac.manchester.tornado.benchmarks.spmv.Benchmark();
            case "stencil" -> new uk.ac.manchester.tornado.benchmarks.stencil.Benchmark();
            default -> throw new TornadoRuntimeException("Benchmark not recognized: " + benchmark);
        };
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            String helpMessage = "[ERROR] Provide a benchmark to run \n Example: $ tornado uk.ac.manchester.tornado.benchmarks.BenchmarkRunner juliaset 10 4096";
            System.out.println(helpMessage);
            System.exit(0);
        }
        BenchmarkRunner benchmarkRunner = BenchmarkRunner.getBenchMarkInstance(args[0]);
        String[] benchmarkArgs = Arrays.copyOfRange(args, 1, args.length);
        if (System.getProperty("config") != null) {
            TornadoRuntimeProvider.loadSettings((String)System.getProperty("config"));
        }
        benchmarkRunner.parseArgs(benchmarkArgs);
        benchmarkRunner.run();
    }
}

