/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.benchmarks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.TornadoProfilerResult;
import uk.ac.manchester.tornado.api.TornadoRuntime;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.utils.TornadoAPIUtils;

public abstract class BenchmarkDriver {
    private static final boolean PRINT_MEM_USAGE = Boolean.parseBoolean(System.getProperty("tornado.benchmarks.memusage", "False"));
    private static final int ENERGY_MONITOR_INTERVAL = Integer.parseInt(System.getProperty("energy.monitor.interval", "0"));
    private static final String DUMP_ENERGY_METRICS_TO_DIRECTORY = System.getProperty("dump.energy.metrics.to.directory", "");
    private static final boolean VALIDATE = Boolean.parseBoolean(System.getProperty("tornado.benchmarks.validate", "False"));
    public static final float MAX_ULP = Float.parseFloat(System.getProperty("tornado.benchmarks.maxulp", "1000.0"));
    protected final long iterations;
    private double elapsed;
    private double[] timers;
    private List<Long> deviceKernelTimers;
    private List<Long> deviceCopyIn;
    private List<Long> deviceCopyOut;
    private List<Long> totalEnergyMetrics;
    private List<Long> firstPowerMetricPerIteration;
    private List<Long> averagePowerMetricPerIteration;
    private List<Long> lastPowerMetricPerIteration;
    private List<Long> powerMetricsPerIteration;
    private List<Long> snapshotTimerPerIteration;
    private int startingIndex = 30;
    protected TaskGraph taskGraph;
    protected TornadoExecutionPlan executionPlan;
    protected TornadoExecutionResult executionResult;
    protected ImmutableTaskGraph immutableTaskGraph;

    protected BenchmarkDriver(long iterations) {
        this.iterations = iterations;
    }

    public abstract void setUp();

    public void tearDown() {
        Runtime runtime = Runtime.getRuntime();
        if (PRINT_MEM_USAGE) {
            System.out.printf("memory: free=%s, total=%s, max=%s\n", TornadoAPIUtils.humanReadableByteCount((long)runtime.freeMemory(), (boolean)false), TornadoAPIUtils.humanReadableByteCount((long)runtime.totalMemory(), (boolean)false), TornadoAPIUtils.humanReadableByteCount((long)runtime.maxMemory(), (boolean)false));
        }
    }

    public abstract boolean validate(TornadoDevice var1);

    public abstract void runBenchmark(TornadoDevice var1);

    public TaskGraph getTaskGraph() {
        return this.taskGraph;
    }

    public TornadoExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    protected void barrier() {
    }

    public String getProperty(String key, String value) {
        return TornadoRuntimeProvider.getProperty((String)key, (String)value);
    }

    public String getProperty(String key) {
        return TornadoRuntimeProvider.getProperty((String)key);
    }

    private boolean skipGC() {
        return true;
    }

    private boolean isEnergyMonitorIntervalEnabled() {
        return ENERGY_MONITOR_INTERVAL > 0;
    }

    public void benchmark(TornadoDevice device, boolean isProfilerEnabled) {
        this.setUp();
        int size = Math.toIntExact(this.iterations);
        this.timers = new double[size];
        if (isProfilerEnabled) {
            this.deviceKernelTimers = new ArrayList<Long>();
            this.deviceCopyIn = new ArrayList<Long>();
            this.deviceCopyOut = new ArrayList<Long>();
        }
        for (long i = 0L; i < this.iterations; ++i) {
            if (!this.skipGC()) {
                System.gc();
            }
            long start = System.nanoTime();
            this.runBenchmark(device);
            long end = System.nanoTime();
            if (isProfilerEnabled) {
                TornadoProfilerResult profilerResult = this.getExecutionResult().getProfilerResult();
                if (profilerResult.getDeviceKernelTime() != 0L) {
                    this.deviceKernelTimers.add(profilerResult.getDeviceKernelTime());
                }
                if (profilerResult.getDeviceWriteTime() != 0L) {
                    this.deviceCopyIn.add(profilerResult.getDeviceWriteTime());
                }
                if (profilerResult.getDeviceReadTime() != 0L) {
                    this.deviceCopyOut.add(profilerResult.getDeviceReadTime());
                }
            }
            this.timers[Math.toIntExact((long)i)] = end - start;
        }
        this.barrier();
        if (VALIDATE) {
            this.validate(device);
        }
        this.tearDown();
    }

    public void benchmarkWithEnergy(String id, TornadoDevice device, boolean isProfilerEnabled) {
        this.setUp();
        int size = Math.toIntExact(this.iterations);
        this.timers = new double[size];
        if (isProfilerEnabled) {
            this.deviceKernelTimers = new ArrayList<Long>();
            this.deviceCopyIn = new ArrayList<Long>();
            this.deviceCopyOut = new ArrayList<Long>();
        }
        this.totalEnergyMetrics = new ArrayList<Long>();
        this.firstPowerMetricPerIteration = new ArrayList<Long>();
        this.averagePowerMetricPerIteration = new ArrayList<Long>();
        this.lastPowerMetricPerIteration = new ArrayList<Long>();
        for (long i = 0L; i < this.iterations; ++i) {
            this.powerMetricsPerIteration = Collections.synchronizedList(new ArrayList());
            this.snapshotTimerPerIteration = Collections.synchronizedList(new ArrayList());
            Thread t0 = new Thread(() -> this.runBenchmark(device), "BenchmarkThread");
            Thread t1 = new Thread(() -> {
                TornadoRuntime runtime = TornadoRuntimeProvider.getTornadoRuntime();
                while (t0.isAlive()) {
                    if (this.isEnergyMonitorIntervalEnabled()) {
                        try {
                            Thread.sleep(ENERGY_MONITOR_INTERVAL);
                        }
                        catch (InterruptedException e) {
                            System.err.println("The thread for monitoring the power consumption is interrupted: " + e.getMessage());
                            Thread.currentThread().interrupt();
                            throw new TornadoRuntimeException((Exception)e);
                        }
                    }
                    long powerMetric = runtime.getPowerMetric();
                    this.snapshotTimerPerIteration.add(System.nanoTime());
                    this.powerMetricsPerIteration.add(powerMetric);
                }
            }, "PowerMonitoringThread");
            if (!this.skipGC()) {
                System.gc();
            }
            long start = System.nanoTime();
            t0.start();
            t1.start();
            try {
                t0.join();
                t1.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TornadoRuntimeException((Exception)e);
            }
            long end = System.nanoTime();
            if (isProfilerEnabled) {
                TornadoProfilerResult profilerResult = this.getExecutionResult().getProfilerResult();
                if (profilerResult.getDeviceKernelTime() != 0L) {
                    this.deviceKernelTimers.add(profilerResult.getDeviceKernelTime());
                }
                if (profilerResult.getDeviceWriteTime() != 0L) {
                    this.deviceCopyIn.add(profilerResult.getDeviceWriteTime());
                }
                if (profilerResult.getDeviceReadTime() != 0L) {
                    this.deviceCopyOut.add(profilerResult.getDeviceReadTime());
                }
            }
            this.timers[Math.toIntExact((long)i)] = end - start;
            this.totalEnergyMetrics.add(this.calculateTotalEnergy(start));
            this.firstPowerMetricPerIteration.add(this.powerMetricsPerIteration.getFirst());
            this.averagePowerMetricPerIteration.add((long)this.getAverage(this.toArray(this.powerMetricsPerIteration)));
            this.lastPowerMetricPerIteration.add(this.powerMetricsPerIteration.getLast());
        }
        this.barrier();
        if (!DUMP_ENERGY_METRICS_TO_DIRECTORY.isEmpty()) {
            this.writeToCsv(id, device);
            this.writePowerMetricsToCsv(id, device);
        }
        if (VALIDATE) {
            this.validate(device);
        }
        this.tearDown();
    }

    public double getMin(double[] arr) {
        double minValue = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] < minValue)) continue;
            minValue = arr[i];
        }
        return minValue;
    }

    public double getMax(double[] arr) {
        double maxValue = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] > maxValue)) continue;
            maxValue = arr[i];
        }
        return maxValue;
    }

    public double getMedian(double[] arr) {
        double[] temp = (double[])arr.clone();
        Arrays.sort(temp);
        if (temp.length % 2 == 0) {
            return (temp[temp.length / 2] + temp[temp.length / 2 - 1]) / 2.0;
        }
        return temp[temp.length / 2];
    }

    public double[] toArray(List<Long> list) {
        return list.stream().mapToDouble(i -> i.longValue()).toArray();
    }

    public double getBestKernelTime() {
        return this.getMin(this.toArray(this.deviceKernelTimers));
    }

    public double getMedianKernelTime() {
        return this.getMedian(this.toArray(this.deviceKernelTimers));
    }

    public double getAverageKernelTime() {
        return this.getAverage(this.toArray(this.deviceKernelTimers));
    }

    public double getAverageCopyInTime() {
        return this.getAverage(this.toArray(this.deviceCopyIn));
    }

    public double getAverageCopyOutTime() {
        return this.getAverage(this.toArray(this.deviceCopyOut));
    }

    public double getBestExecution() {
        return this.getMin(this.timers);
    }

    public double getFirstIteration() {
        return this.timers[0];
    }

    public double getMedian() {
        return this.getMedian(this.timers);
    }

    public double getAverage(double[] arr) {
        double sum = 0.0;
        int start = this.startingIndex;
        if (arr.length <= this.startingIndex) {
            start = 0;
        }
        for (int i = start; i < arr.length; ++i) {
            sum += arr[i];
        }
        return sum / (double)(arr.length - start);
    }

    public double getAverage() {
        return this.getAverage(this.timers);
    }

    private void writeToCsv(String id, TornadoDevice device) {
        String fileName = "energy_metrics_" + this.formatFileNameSuffix(id, device);
        this.writeListToCSV(this.totalEnergyMetrics, fileName, id);
    }

    private void writePowerMetricsToCsv(String id, TornadoDevice device) {
        String fileName = "first_power_metrics_" + this.formatFileNameSuffix(id, device);
        this.writeListToCSV(this.firstPowerMetricPerIteration, fileName, id);
        fileName = "average_power_metrics_" + this.formatFileNameSuffix(id, device);
        this.writeListToCSV(this.averagePowerMetricPerIteration, fileName, id);
        fileName = "last_power_metrics_" + this.formatFileNameSuffix(id, device);
        this.writeListToCSV(this.lastPowerMetricPerIteration, fileName, id);
    }

    private String formatFileNameSuffix(String id, TornadoDevice device) {
        String currentSetup = device != null ? device.toString() : "java_reference";
        String[] idParts = id.split("-");
        return idParts[0] + "_" + currentSetup + ".csv";
    }

    private void writeListToCSV(List list, String fileName, String id) {
        try (FileWriter writer = new FileWriter(new File(DUMP_ENERGY_METRICS_TO_DIRECTORY, fileName), true);){
            String[] idParts = id.split("-");
            String benchmarkName = idParts[0];
            String dataSize = idParts[idParts.length - 1];
            writer.append(benchmarkName).append(",").append(dataSize).append(",");
            this.writeListToFileWriter(list, writer);
            writer.append("\n");
            System.out.println("Updated CSV file (" + fileName + ") with new energy metrics for " + id + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeListToFileWriter(List list, FileWriter writer) throws IOException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            writer.append(String.valueOf(list.get(i)));
            if (i >= size - 1) continue;
            writer.append(",");
        }
    }

    public long getFirstEnergyMetric() {
        return this.totalEnergyMetrics.getFirst();
    }

    public long getAverageEnergyMetric() {
        return (long)this.getAverage(this.toArray(this.totalEnergyMetrics));
    }

    public long getLowestEnergyMetric() {
        return (long)this.getMin(this.toArray(this.totalEnergyMetrics));
    }

    public long getHighestEnergyMetric() {
        return (long)this.getMax(this.toArray(this.totalEnergyMetrics));
    }

    public double getVariance() {
        double mean = this.getAverage();
        double temp = 0.0;
        for (int i = this.startingIndex; i < this.timers.length; ++i) {
            temp += (this.timers[i] - mean) * (this.timers[i] - mean);
        }
        return temp / (double)(this.iterations - (long)this.startingIndex);
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public double getCV() {
        return this.getStdDev() / this.getAverage() * 100.0;
    }

    public double getElapsed() {
        return this.elapsed;
    }

    public double getElapsedPerIteration() {
        return this.elapsed / (double)this.iterations;
    }

    public String getPreciseSummary() {
        return String.format("average(ns)=%6e, median(ns)=%6e, firstIteration(ns)=%6e, best(ns)=%6e%n", this.getAverage(), this.getMedian(), this.getFirstIteration(), this.getBestExecution());
    }

    private Long calculateTotalEnergy(long startTime) {
        long totalEnergy = 0L;
        if (this.snapshotTimerPerIteration.size() == this.powerMetricsPerIteration.size()) {
            long timeInterval = this.snapshotTimerPerIteration.get(0) - startTime;
            long energyForInterval = (timeInterval /= 1000000L) * this.powerMetricsPerIteration.get(0);
            totalEnergy += energyForInterval;
            for (int i = 0; i < this.snapshotTimerPerIteration.size() - 1; ++i) {
                timeInterval = this.snapshotTimerPerIteration.get(i + 1) - this.snapshotTimerPerIteration.get(i);
                energyForInterval = timeInterval * this.powerMetricsPerIteration.get(i + 1);
                totalEnergy += energyForInterval;
            }
        } else {
            throw new IllegalArgumentException("All lists must have the same size.");
        }
        return totalEnergy;
    }

    public String getEnergySummary() {
        return String.format("firstIteration(mJ)=%d, lowestEnergy(mJ)=%d, averageEnergy(mJ)=%d, highestEnergy(mJ)=%d%n", this.getFirstEnergyMetric(), this.getLowestEnergyMetric(), this.getAverageEnergyMetric(), this.getHighestEnergyMetric());
    }

    public String getSummary() {
        return String.format("elapsed=%6e, per iteration=%6e", this.getElapsed(), this.getElapsedPerIteration());
    }
}

