/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.utils;

import uk.ac.manchester.tornado.api.types.arrays.Int8Array;

public class QuantizationUtils {
    public static int dp4a(Int8Array a, long offsetA, Int8Array b, long offsetB, int c) {
        if ((long)a.getSize() < offsetA + 4L || (long)b.getSize() < offsetB + 4L) {
            throw new IllegalArgumentException("Array slice is out of bounds for the given offset.");
        }
        int dotProduct = 0;
        for (int i = 0; i < 4; ++i) {
            dotProduct += a.get((int)offsetA + i) * b.get((int)offsetB + i);
        }
        return c + dotProduct;
    }

    public static int dp4a(Int8Array aGlobal, long offsetA, byte[] bLocal, long offsetB, int c) {
        if ((long)aGlobal.getSize() < offsetA + 4L || (long)bLocal.length < offsetB + 4L) {
            throw new IllegalArgumentException("Array slice is out of bounds for the given offset.");
        }
        int dotProduct = 0;
        for (int i = 0; i < 4; ++i) {
            dotProduct += aGlobal.get((int)offsetA + i) * bLocal[(int)offsetB + i];
        }
        return c + dotProduct;
    }

    public static float dequantizeFusedResult(int dotProductResult, float wScale, float xScale) {
        return (float)dotProductResult * wScale * xScale;
    }

    public static int dp4a_packed(int a, int b, int c) {
        int sum = c;
        for (int i = 0; i < 4; ++i) {
            byte aByte = (byte)(a >> i * 8 & 0xFF);
            byte bByte = (byte)(b >> i * 8 & 0xFF);
            sum += aByte * bByte;
        }
        return sum;
    }
}

