/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.vectors.Half4;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Half8
implements TornadoVectorsInterface<ShortBuffer> {
    public static final Class<Half8> TYPE = Half8.class;
    private static final int NUM_ELEMENTS = 8;
    @Payload
    short[] storage = new short[8];

    private Half8(HalfFloat[] storage) {
        for (int i = 0; i < 8; ++i) {
            this.storage[i] = storage[i].getHalfFloatValue();
        }
    }

    public Half8() {
        this.storage = new short[8];
    }

    public Half8(HalfFloat s0, HalfFloat s1, HalfFloat s2, HalfFloat s3, HalfFloat s4, HalfFloat s5, HalfFloat s6, HalfFloat s7) {
        this();
        this.setS0(s0);
        this.setS1(s1);
        this.setS2(s2);
        this.setS3(s3);
        this.setS4(s4);
        this.setS5(s5);
        this.setS6(s6);
        this.setS7(s7);
    }

    public static Half8 add(Half8 a, Half8 b) {
        Half8 result = new Half8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, HalfFloat.add(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Half8 add(Half8 a, HalfFloat b) {
        Half8 result = new Half8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, HalfFloat.add(a.get(i), b));
        }
        return result;
    }

    public static Half8 sub(Half8 a, Half8 b) {
        Half8 result = new Half8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, HalfFloat.sub(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Half8 sub(Half8 a, HalfFloat b) {
        Half8 result = new Half8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, HalfFloat.sub(a.get(i), b));
        }
        return result;
    }

    public static Half8 div(Half8 a, Half8 b) {
        Half8 result = new Half8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, HalfFloat.div(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Half8 div(Half8 a, HalfFloat value) {
        Half8 result = new Half8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, HalfFloat.div(a.get(i), value));
        }
        return result;
    }

    public static Half8 mult(Half8 a, Half8 b) {
        Half8 result = new Half8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, HalfFloat.mult(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Half8 mult(Half8 a, HalfFloat value) {
        Half8 result = new Half8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, HalfFloat.mult(a.get(i), value));
        }
        return result;
    }

    public static HalfFloat dot(Half8 a, Half8 b) {
        Half8 m = Half8.mult(a, b);
        return HalfFloat.add(HalfFloat.add(HalfFloat.add(m.getS0(), m.getS1()), HalfFloat.add(m.getS2(), m.getS3())), HalfFloat.add(HalfFloat.add(m.getS4(), m.getS5()), HalfFloat.add(m.getS6(), m.getS7())));
    }

    public short[] getArray() {
        return this.storage;
    }

    public HalfFloat get(int index) {
        return new HalfFloat(this.storage[index]);
    }

    public void set(int index, HalfFloat value) {
        this.storage[index] = value.getHalfFloatValue();
    }

    public void set(Half8 value) {
        for (int i = 0; i < 8; ++i) {
            this.set(i, value.get(i));
        }
    }

    public HalfFloat getS0() {
        return this.get(0);
    }

    public void setS0(HalfFloat value) {
        this.set(0, value);
    }

    public HalfFloat getS1() {
        return this.get(1);
    }

    public void setS1(HalfFloat value) {
        this.set(1, value);
    }

    public HalfFloat getS2() {
        return this.get(2);
    }

    public void setS2(HalfFloat value) {
        this.set(2, value);
    }

    public HalfFloat getS3() {
        return this.get(3);
    }

    public void setS3(HalfFloat value) {
        this.set(3, value);
    }

    public HalfFloat getS4() {
        return this.get(4);
    }

    public void setS4(HalfFloat value) {
        this.set(4, value);
    }

    public HalfFloat getS5() {
        return this.get(5);
    }

    public void setS5(HalfFloat value) {
        this.set(5, value);
    }

    public HalfFloat getS6() {
        return this.get(6);
    }

    public void setS6(HalfFloat value) {
        this.set(6, value);
    }

    public HalfFloat getS7() {
        return this.get(7);
    }

    public void setS7(HalfFloat value) {
        this.set(7, value);
    }

    public Half4 getHigh() {
        return new Half4(this.getS4(), this.getS5(), this.getS6(), this.getS7());
    }

    public Half4 getLow() {
        return new Half4(this.getS0(), this.getS1(), this.getS2(), this.getS3());
    }

    public Half8 duplicate() {
        Half8 vector = new Half8();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getS0().getFloat32()), Float.valueOf(this.getS1().getFloat32()), Float.valueOf(this.getS2().getFloat32()), Float.valueOf(this.getS3().getFloat32()), Float.valueOf(this.getS4().getFloat32()), Float.valueOf(this.getS5().getFloat32()), Float.valueOf(this.getS6().getFloat32()), Float.valueOf(this.getS7().getFloat32()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 8;
    }

    public short[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 16L;
    }
}

