/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Double4;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Double8
implements TornadoVectorsInterface<DoubleBuffer> {
    public static final Class<Double8> TYPE = Double8.class;
    private static final int NUM_ELEMENTS = 8;
    @Payload
    final double[] storage;

    private Double8(double[] storage) {
        this.storage = storage;
    }

    public Double8() {
        this(new double[8]);
    }

    public Double8(double s0, double s1, double s2, double s3, double s4, double s5, double s6, double s7) {
        this();
        this.setS0(s0);
        this.setS1(s1);
        this.setS2(s2);
        this.setS3(s3);
        this.setS4(s4);
        this.setS5(s5);
        this.setS6(s6);
        this.setS7(s7);
    }

    public static Double8 add(Double8 a, Double8 b) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) + b.get(i));
        }
        return result;
    }

    public static Double8 add(Double8 a, double b) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) + b);
        }
        return result;
    }

    public static Double8 sub(Double8 a, Double8 b) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) - b.get(i));
        }
        return result;
    }

    public static Double8 sub(Double8 a, double b) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) - b);
        }
        return result;
    }

    public static Double8 div(Double8 a, Double8 b) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) / b.get(i));
        }
        return result;
    }

    public static Double8 div(Double8 a, double value) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) / value);
        }
        return result;
    }

    public static Double8 mult(Double8 a, Double8 b) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) * b.get(i));
        }
        return result;
    }

    public static Double8 mult(Double8 a, double value) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, a.get(i) * value);
        }
        return result;
    }

    public static Double8 min(Double8 a, Double8 b) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.min(a.get(i), b.get(i)));
        }
        return result;
    }

    public static double min(Double8 value) {
        double result = Double.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            result = Math.min(result, value.get(i));
        }
        return result;
    }

    public static Double8 max(Double8 a, Double8 b) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, Math.max(a.get(i), b.get(i)));
        }
        return result;
    }

    public static double max(Double8 value) {
        double result = Double.MIN_VALUE;
        for (int i = 0; i < 8; ++i) {
            result = Math.max(result, value.get(i));
        }
        return result;
    }

    public static Double8 sqrt(Double8 a) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            a.set(i, TornadoMath.sqrt(a.get(i)));
        }
        return result;
    }

    public static boolean isEqual(Double8 a, Double8 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public static double findULPDistance(Double8 value, Double8 expected) {
        return TornadoMath.findULPDistance(value.asBuffer().array(), expected.asBuffer().array());
    }

    public double[] getArray() {
        return this.storage;
    }

    public double get(int index) {
        return this.storage[index];
    }

    public void set(int index, double value) {
        this.storage[index] = value;
    }

    public void set(Double8 value) {
        for (int i = 0; i < 8; ++i) {
            this.set(i, value.get(i));
        }
    }

    public double getS0() {
        return this.get(0);
    }

    public void setS0(double value) {
        this.set(0, value);
    }

    public double getS1() {
        return this.get(1);
    }

    public void setS1(double value) {
        this.set(1, value);
    }

    public double getS2() {
        return this.get(2);
    }

    public void setS2(double value) {
        this.set(2, value);
    }

    public double getS3() {
        return this.get(3);
    }

    public void setS3(double value) {
        this.set(3, value);
    }

    public double getS4() {
        return this.get(4);
    }

    public void setS4(double value) {
        this.set(4, value);
    }

    public double getS5() {
        return this.get(5);
    }

    public void setS5(double value) {
        this.set(5, value);
    }

    public double getS6() {
        return this.get(6);
    }

    public void setS6(double value) {
        this.set(6, value);
    }

    public double getS7() {
        return this.get(7);
    }

    public void setS7(double value) {
        this.set(7, value);
    }

    public Double4 getHigh() {
        return new Double4(this.getS4(), this.getS5(), this.getS6(), this.getS7());
    }

    public Double4 getLow() {
        return new Double4(this.getS0(), this.getS1(), this.getS2(), this.getS3());
    }

    public Double8 duplicate() {
        Double8 vector = new Double8();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getS0(), this.getS1(), this.getS2(), this.getS3(), this.getS4(), this.getS5(), this.getS6(), this.getS7());
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 8;
    }

    public double[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 64L;
    }
}

