/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Double2
implements TornadoVectorsInterface<DoubleBuffer> {
    public static final Class<Double2> TYPE = Double2.class;
    private static final int NUM_ELEMENTS = 2;
    @Payload
    final double[] storage;

    private Double2(double[] storage) {
        this.storage = storage;
    }

    public Double2() {
        this(new double[2]);
    }

    public Double2(double x, double y) {
        this();
        this.setX(x);
        this.setY(y);
    }

    public static Double2 add(Double2 a, Double2 b) {
        return new Double2(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Double2 sub(Double2 a, Double2 b) {
        return new Double2(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static Double2 div(Double2 a, Double2 b) {
        return new Double2(a.getX() / b.getX(), a.getY() / b.getY());
    }

    public static Double2 mult(Double2 a, Double2 b) {
        return new Double2(a.getX() * b.getX(), a.getY() * b.getY());
    }

    public static Double2 min(Double2 a, Double2 b) {
        return new Double2(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()));
    }

    public static Double2 max(Double2 a, Double2 b) {
        return new Double2(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()));
    }

    public static Double2 add(Double2 a, double b) {
        return new Double2(a.getX() + b, a.getY() + b);
    }

    public static Double2 sub(Double2 a, double b) {
        return new Double2(a.getX() - b, a.getY() - b);
    }

    public static Double2 mult(Double2 a, double b) {
        return new Double2(a.getX() * b, a.getY() * b);
    }

    public static Double2 div(Double2 a, double b) {
        return new Double2(a.getX() / b, a.getY() / b);
    }

    public static void add(Double2 a, Double2 b, Double2 c) {
        c.setX(a.getX() + b.getX());
        c.setY(a.getY() + b.getY());
    }

    public static void sub(Double2 a, Double2 b, Double2 c) {
        c.setX(a.getX() - b.getX());
        c.setY(a.getY() - b.getY());
    }

    public static void mult(Double2 a, Double2 b, Double2 c) {
        c.setX(a.getX() * b.getX());
        c.setY(a.getY() * b.getY());
    }

    public static void div(Double2 a, Double2 b, Double2 c) {
        c.setX(a.getX() / b.getX());
        c.setY(a.getY() / b.getY());
    }

    public static void min(Double2 a, Double2 b, Double2 c) {
        c.setX(Math.min(a.getX(), b.getX()));
        c.setY(Math.min(a.getY(), b.getY()));
    }

    public static void max(Double2 a, Double2 b, Double2 c) {
        c.setX(Math.max(a.getX(), b.getX()));
        c.setY(Math.max(a.getY(), b.getY()));
    }

    public static Double2 inc(Double2 a, double value) {
        return Double2.add(a, value);
    }

    public static Double2 dec(Double2 a, double value) {
        return Double2.sub(a, value);
    }

    public static Double2 scaleByInverse(Double2 a, double value) {
        return Double2.mult(a, 1.0 / value);
    }

    public static Double2 scale(Double2 a, double value) {
        return Double2.mult(a, value);
    }

    public static Double2 sqrt(Double2 a) {
        return new Double2(TornadoMath.sqrt(a.getX()), TornadoMath.sqrt(a.getY()));
    }

    public static Double2 floor(Double2 a) {
        return new Double2(TornadoMath.floor(a.getX()), TornadoMath.floor(a.getY()));
    }

    public static Double2 fract(Double2 a) {
        return new Double2(TornadoMath.fract(a.getX()), TornadoMath.fract(a.getY()));
    }

    public static void clamp(Double2 x, double min, double max) {
        x.setX(TornadoMath.clamp(x.getX(), min, max));
        x.setY(TornadoMath.clamp(x.getY(), min, max));
    }

    public static void normalise(Double2 value) {
        double len = Double2.length(value);
        Double2.scaleByInverse(value, len);
    }

    public static double min(Double2 value) {
        return Math.min(value.getX(), value.getY());
    }

    public static double max(Double2 value) {
        return Math.max(value.getX(), value.getY());
    }

    public static double dot(Double2 a, Double2 b) {
        Double2 m = Double2.mult(a, b);
        return m.getX() + m.getY();
    }

    public static double length(Double2 value) {
        return TornadoMath.sqrt(Double2.dot(value, value));
    }

    public static boolean isEqual(Double2 a, Double2 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public double[] getArray() {
        return this.storage;
    }

    public double get(int index) {
        return this.storage[index];
    }

    public void set(int index, double value) {
        this.storage[index] = value;
    }

    public void set(Double2 value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public double getX() {
        return this.get(0);
    }

    public void setX(double value) {
        this.set(0, value);
    }

    public double getY() {
        return this.get(1);
    }

    public void setY(double value) {
        this.set(1, value);
    }

    public Double2 duplicate() {
        Double2 vector = new Double2();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY());
    }

    public String toString() {
        return this.toString("{%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 2;
    }

    public double[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 16L;
    }
}

