/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ByteBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Byte3
implements TornadoVectorsInterface<ByteBuffer> {
    public static final Class<Byte3> TYPE = Byte3.class;
    private static final String NUMBER_FORMAT = "{ x=%-7d, y=%-7d, z=%-7d }";
    private static final int NUM_ELEMENTS = 3;
    @Payload
    private final byte[] storage;

    private Byte3(byte[] nativeVectorByte) {
        this.storage = nativeVectorByte;
    }

    public Byte3() {
        this(new byte[3]);
    }

    public Byte3(byte x, byte y, byte z) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public static Byte3 add(Byte3 a, Byte3 b) {
        return new Byte3((byte)(a.getX() + b.getX()), (byte)(a.getY() + b.getY()), (byte)(a.getZ() + b.getZ()));
    }

    public static Byte3 sub(Byte3 a, Byte3 b) {
        return new Byte3((byte)(a.getX() - b.getX()), (byte)(a.getY() - b.getY()), (byte)(a.getZ() - b.getZ()));
    }

    public static Byte3 div(Byte3 a, Byte3 b) {
        return new Byte3((byte)(a.getX() / b.getX()), (byte)(a.getY() / b.getY()), (byte)(a.getZ() / b.getZ()));
    }

    public static Byte3 mult(Byte3 a, Byte3 b) {
        return new Byte3((byte)(a.getX() * b.getX()), (byte)(a.getY() * b.getY()), (byte)(a.getZ() * b.getZ()));
    }

    public static Byte3 min(Byte3 a, Byte3 b) {
        return new Byte3(TornadoMath.min(a.getX(), b.getX()), TornadoMath.min(a.getY(), b.getY()), TornadoMath.min(a.getZ(), b.getZ()));
    }

    public static Byte3 max(Byte3 a, Byte3 b) {
        return new Byte3(TornadoMath.max(a.getX(), b.getX()), TornadoMath.max(a.getY(), b.getY()), TornadoMath.max(a.getZ(), b.getZ()));
    }

    public static Byte3 add(Byte3 a, byte b) {
        return new Byte3((byte)(a.getX() + b), (byte)(a.getY() + b), (byte)(a.getZ() + b));
    }

    public static Byte3 sub(Byte3 a, byte b) {
        return new Byte3((byte)(a.getX() - b), (byte)(a.getY() - b), (byte)(a.getZ() - b));
    }

    public static Byte3 mult(Byte3 a, byte b) {
        return new Byte3((byte)(a.getX() * b), (byte)(a.getY() * b), (byte)(a.getZ() * b));
    }

    public static Byte3 div(Byte3 a, byte b) {
        return new Byte3((byte)(a.getX() / b), (byte)(a.getY() / b), (byte)(a.getZ() / b));
    }

    public static Byte3 inc(Byte3 a, byte value) {
        return Byte3.add(a, value);
    }

    public static Byte3 dec(Byte3 a, byte value) {
        return Byte3.sub(a, value);
    }

    public static Byte3 scale(Byte3 a, byte value) {
        return Byte3.mult(a, value);
    }

    public static Byte3 clamp(Byte3 x, byte min, byte max) {
        return new Byte3(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max), TornadoMath.clamp(x.getZ(), min, max));
    }

    public static byte min(Byte3 value) {
        return TornadoMath.min(value.getX(), TornadoMath.min(value.getY(), value.getZ()));
    }

    public static byte max(Byte3 value) {
        return TornadoMath.max(value.getX(), TornadoMath.max(value.getY(), value.getZ()));
    }

    public static boolean isEqual(Byte3 a, Byte3 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public void set(Byte3 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
    }

    public byte get(int index) {
        return this.storage[index];
    }

    public void set(int index, byte value) {
        this.storage[index] = value;
    }

    public byte getX() {
        return this.get(0);
    }

    public void setX(byte value) {
        this.set(0, value);
    }

    public byte getY() {
        return this.get(1);
    }

    public void setY(byte value) {
        this.set(1, value);
    }

    public byte getZ() {
        return this.get(2);
    }

    public void setZ(byte value) {
        this.set(2, value);
    }

    public Byte3 duplicate() {
        Byte3 vector = new Byte3();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY(), this.getZ());
    }

    public String toString() {
        return this.toString(NUMBER_FORMAT);
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ByteBuffer asBuffer() {
        return ByteBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 3;
    }

    public byte[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 3L;
    }
}

