/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.utils;

import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Int3;
import uk.ac.manchester.tornado.api.types.volumes.VolumeShort2;

public class VolumeOps {
    public static Float3 grad(VolumeShort2 volume, Float3 dim, Float3 point) {
        Float3 scaledPos = new Float3(point.getX() * (float)volume.X() / dim.getX() - 0.5f, point.getY() * (float)volume.Y() / dim.getY() - 0.5f, point.getZ() * (float)volume.Z() / dim.getZ() - 0.5f);
        Float3 tmp = Float3.floor(scaledPos);
        Float3 factor = Float3.fract(scaledPos);
        Int3 base = new Int3((int)tmp.getX(), (int)tmp.getY(), (int)tmp.getZ());
        Int3 zeros = new Int3();
        Int3 limits = Int3.sub(new Int3(volume.X(), volume.Y(), volume.Z()), 1);
        Int3 lowerLower = Int3.max(zeros, Int3.sub(base, 1));
        Int3 lowerUpper = Int3.max(zeros, base);
        Int3 upperLower = Int3.min(limits, Int3.add(base, 1));
        Int3 upperUpper = Int3.min(limits, Int3.add(base, 2));
        Int3 lower = lowerUpper;
        Int3 upper = upperLower;
        float gx = (((VolumeOps.vs(volume, upperLower.getX(), lower.getY(), lower.getZ()) - VolumeOps.vs(volume, lowerLower.getX(), lower.getY(), lower.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upperUpper.getX(), lower.getY(), lower.getZ()) - VolumeOps.vs(volume, lowerUpper.getX(), lower.getY(), lower.getZ())) * factor.getX()) * (1.0f - factor.getY()) + ((VolumeOps.vs(volume, upperLower.getX(), upper.getY(), lower.getZ()) - VolumeOps.vs(volume, lowerLower.getX(), upper.getY(), lower.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upperUpper.getX(), upper.getY(), lower.getZ()) - VolumeOps.vs(volume, lowerUpper.getX(), upper.getY(), lower.getZ())) * factor.getX()) * factor.getY()) * (1.0f - factor.getZ()) + (((VolumeOps.vs(volume, upperLower.getX(), lower.getY(), upper.getZ()) - VolumeOps.vs(volume, lowerLower.getX(), lower.getY(), upper.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upperUpper.getX(), lower.getY(), upper.getZ()) - VolumeOps.vs(volume, lowerUpper.getX(), lower.getY(), upper.getZ())) * factor.getX()) * (1.0f - factor.getY()) + ((VolumeOps.vs(volume, upperLower.getX(), upper.getY(), upper.getZ()) - VolumeOps.vs(volume, lowerLower.getX(), upper.getY(), upper.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upperUpper.getX(), upper.getY(), upper.getZ()) - VolumeOps.vs(volume, lowerUpper.getX(), upper.getY(), upper.getZ())) * factor.getX()) * factor.getY()) * factor.getZ();
        float gy = (((VolumeOps.vs(volume, lower.getX(), upperLower.getY(), lower.getZ()) - VolumeOps.vs(volume, lower.getX(), lowerLower.getY(), lower.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upper.getX(), upperLower.getY(), lower.getZ()) - VolumeOps.vs(volume, upper.getX(), lowerLower.getY(), lower.getZ())) * factor.getX()) * (1.0f - factor.getY()) + ((VolumeOps.vs(volume, lower.getX(), upperUpper.getY(), lower.getZ()) - VolumeOps.vs(volume, lower.getX(), lowerUpper.getY(), lower.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upper.getX(), upperUpper.getY(), lower.getZ()) - VolumeOps.vs(volume, upper.getX(), lowerUpper.getY(), lower.getZ())) * factor.getX()) * factor.getY()) * (1.0f - factor.getZ()) + (((VolumeOps.vs(volume, lower.getX(), upperLower.getY(), upper.getZ()) - VolumeOps.vs(volume, lower.getX(), lowerLower.getY(), upper.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upper.getX(), upperLower.getY(), upper.getZ()) - VolumeOps.vs(volume, upper.getX(), lowerLower.getY(), upper.getZ())) * factor.getX()) * (1.0f - factor.getY()) + ((VolumeOps.vs(volume, lower.getX(), upperUpper.getY(), upper.getZ()) - VolumeOps.vs(volume, lower.getX(), lowerUpper.getY(), upper.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upper.getX(), upperUpper.getY(), upper.getZ()) - VolumeOps.vs(volume, upper.getX(), lowerUpper.getY(), upper.getZ())) * factor.getX()) * factor.getY()) * factor.getZ();
        float gz = (((VolumeOps.vs(volume, lower.getX(), lower.getY(), upperLower.getZ()) - VolumeOps.vs(volume, lower.getX(), lower.getY(), lowerLower.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upper.getX(), lower.getY(), upperLower.getZ()) - VolumeOps.vs(volume, upper.getX(), lower.getY(), lowerLower.getZ())) * factor.getX()) * (1.0f - factor.getY()) + ((VolumeOps.vs(volume, lower.getX(), upper.getY(), upperLower.getZ()) - VolumeOps.vs(volume, lower.getX(), upper.getY(), lowerLower.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upper.getX(), upper.getY(), upperLower.getZ()) - VolumeOps.vs(volume, upper.getX(), upper.getY(), lowerLower.getZ())) * factor.getX()) * factor.getY()) * (1.0f - factor.getZ()) + (((VolumeOps.vs(volume, lower.getX(), lower.getY(), upperUpper.getZ()) - VolumeOps.vs(volume, lower.getX(), lower.getY(), lowerUpper.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upper.getX(), lower.getY(), upperUpper.getZ()) - VolumeOps.vs(volume, upper.getX(), lower.getY(), lowerUpper.getZ())) * factor.getX()) * (1.0f - factor.getY()) + ((VolumeOps.vs(volume, lower.getX(), upper.getY(), upperUpper.getZ()) - VolumeOps.vs(volume, lower.getX(), upper.getY(), lowerUpper.getZ())) * (1.0f - factor.getX()) + (VolumeOps.vs(volume, upper.getX(), upper.getY(), upperUpper.getZ()) - VolumeOps.vs(volume, upper.getX(), upper.getY(), lowerUpper.getZ())) * factor.getX()) * factor.getY()) * factor.getZ();
        Float3 tmp1 = Float3.mult(new Float3(dim.getX() / (float)volume.X(), dim.getY() / (float)volume.Y(), dim.getZ() / (float)volume.Z()), 1.525972E-5f);
        return Float3.mult(new Float3(gx, gy, gz), tmp1);
    }

    public static float interp(VolumeShort2 volume, Float3 dim, Float3 point) {
        Float3 scaledPos = new Float3(point.getX() * (float)volume.X() / dim.getX() - 0.5f, point.getY() * (float)volume.Y() / dim.getY() - 0.5f, point.getZ() * (float)volume.Z() / dim.getZ() - 0.5f);
        Float3 tmp = Float3.floor(scaledPos);
        Float3 factor = Float3.fract(scaledPos);
        Int3 base = new Int3((int)tmp.getX(), (int)tmp.getY(), (int)tmp.getZ());
        Int3 zeros = new Int3(0, 0, 0);
        Int3 limits = Int3.sub(new Int3(volume.X(), volume.Y(), volume.Z()), 1);
        Int3 lower = Int3.max(base, zeros);
        Int3 upper = Int3.min(limits, Int3.add(base, 1));
        float factorX = 1.0f - factor.getX();
        float factorY = 1.0f - factor.getY();
        float factorZ = 1.0f - factor.getZ();
        float c00 = VolumeOps.vs(volume, lower.getX(), lower.getY(), lower.getZ()) * factorX + VolumeOps.vs(volume, upper.getX(), lower.getY(), lower.getZ()) * factor.getX();
        float c10 = VolumeOps.vs(volume, lower.getX(), upper.getY(), lower.getZ()) * factorX + VolumeOps.vs(volume, upper.getX(), upper.getY(), lower.getZ()) * factor.getX();
        float c01 = VolumeOps.vs(volume, lower.getX(), lower.getY(), upper.getZ()) * factorX + VolumeOps.vs(volume, upper.getX(), lower.getY(), upper.getZ()) * factor.getX();
        float c11 = VolumeOps.vs(volume, lower.getX(), upper.getY(), upper.getZ()) * factorX + VolumeOps.vs(volume, upper.getX(), upper.getY(), upper.getZ()) * factor.getX();
        float c0 = c00 * factorY + c10 * factor.getY();
        float c1 = c01 * factorY + c11 * factor.getY();
        float c = c0 * factorZ + c1 * factor.getZ();
        float v = c * 3.051944E-5f;
        return v;
    }

    public static float vs1(int x, int y, int z, VolumeShort2 v) {
        return VolumeOps.vs(v, x, y, z);
    }

    public static float vs(VolumeShort2 cube, int x, int y, int z) {
        return cube.get(x, y, z).getX();
    }
}

