/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.matrix;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DType;
import uk.ac.manchester.tornado.api.types.matrix.TornadoMatrixInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;
import uk.ac.manchester.tornado.api.types.vectors.Float4;

public final class Matrix2DFloat4
extends Matrix2DType
implements TornadoMatrixInterface<FloatBuffer> {
    public static final Class<Matrix2DFloat4> TYPE = Matrix2DFloat4.class;
    private static final int VECTOR_ELEMENTS = 4;
    private final FloatArray storage;
    private final int numElements;

    public Matrix2DFloat4(int rows, int columns, FloatArray array) {
        super(rows, columns);
        this.storage = array;
        this.numElements = columns * rows * 4;
    }

    public Matrix2DFloat4(int rows, int columns) {
        this(rows, columns, new FloatArray(rows * columns * 4));
    }

    public static void transpose(Matrix2DFloat4 matrix) {
        if (matrix.COLUMNS == matrix.ROWS) {
            for (int i = 0; i < matrix.ROWS; ++i) {
                for (int j = 0; j < i; ++j) {
                    Float4 tmp = matrix.get(i, j);
                    matrix.set(i, j, matrix.get(j, i));
                    matrix.set(j, i, tmp);
                }
            }
        } else {
            throw new TornadoRuntimeException("Square matrix expected");
        }
    }

    public static void scale(Matrix2DFloat4 matrix, float value) {
        for (int i = 0; i < matrix.storage.getSize(); ++i) {
            matrix.storage.set(i, matrix.storage.get(i) * value);
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    public Float4 get(int i, int j) {
        int baseIndex = StorageFormats.toRowMajorVector(i, j, this.COLUMNS, 4);
        return this.loadFromArray(this.storage, baseIndex);
    }

    private Float4 loadFromArray(FloatArray array, int index) {
        Float4 result = new Float4();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        result.setW(array.get(index + 3));
        return result;
    }

    public void set(int i, int j, Float4 value) {
        int baseIndex = StorageFormats.toRowMajorVector(i, j, this.COLUMNS, 4);
        this.storeToArray(value, this.storage, baseIndex);
    }

    private void storeToArray(Float4 value, FloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
        array.set(index + 3, value.getW());
    }

    public VectorFloat row(int row) {
        int index = StorageFormats.toRowMajor(row, 0, this.COLUMNS);
        int to = this.getFinalIndexOfRange(index);
        int size = to - index;
        FloatArray f = new FloatArray(size);
        int j = 0;
        for (int i = index; i < to; ++i) {
            f.set(j, this.storage.get(i));
            ++j;
        }
        return new VectorFloat(this.COLUMNS, f);
    }

    public VectorFloat column(int col) {
        int index = StorageFormats.toRowMajor(0, col, this.COLUMNS);
        VectorFloat v = new VectorFloat(this.ROWS);
        for (int i = 0; i < this.ROWS; ++i) {
            v.set(i, this.storage.get(index + i * this.COLUMNS));
        }
        return v;
    }

    public VectorFloat diag() {
        VectorFloat v = new VectorFloat(Math.min(this.ROWS, this.COLUMNS));
        for (int i = 0; i < this.ROWS; ++i) {
            v.set(i, this.storage.get(i * (this.COLUMNS + 1)));
        }
        return v;
    }

    public void fill(float value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public void multiply(Matrix2DFloat4 a, Matrix2DFloat4 b) {
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumColumns(); ++col) {
                Float4 sum = new Float4();
                for (int k = 0; k < b.getNumRows(); ++k) {
                    Float4 fa = a.get(row, k);
                    Float4 fb = b.get(k, col);
                    Float4 fc = Float4.mult(fa, fb);
                    sum = Float4.add(fc, sum);
                }
                this.set(row, col, sum);
            }
        }
    }

    public Matrix2DFloat4 duplicate() {
        Matrix2DFloat4 matrix = new Matrix2DFloat4(this.ROWS, this.COLUMNS);
        matrix.set(this);
        return matrix;
    }

    public void set(Matrix2DFloat4 m) {
        for (int i = 0; i < m.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < this.ROWS; ++i) {
            for (int j = 0; j < this.COLUMNS; ++j) {
                str.append(String.format(fmt, this.get(i, j)) + " ");
            }
            str.append("\n");
        }
        return str.toString().trim();
    }

    public String toString() {
        Object result = String.format("MatrixFloat <%d x %d>", this.ROWS, this.COLUMNS);
        if (this.ROWS < 16 && this.COLUMNS < 16) {
            result = (String)result + "\n" + this.toString("%.3f");
        }
        return result;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.storage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.storage.getSegmentWithHeader();
    }
}

