/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.matrix;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.VectorFloat;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DType;
import uk.ac.manchester.tornado.api.types.matrix.TornadoMatrixInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;

public final class Matrix2DFloat
extends Matrix2DType
implements TornadoMatrixInterface<FloatBuffer> {
    private final FloatArray storage;
    private final int numElements;

    public Matrix2DFloat(int rows, int columns, FloatArray array) {
        super(rows, columns);
        this.storage = array;
        this.numElements = columns * rows;
    }

    public Matrix2DFloat(int rows, int columns) {
        this(rows, columns, new FloatArray(rows * columns));
    }

    public Matrix2DFloat(float[][] matrix) {
        this(matrix.length, matrix[0].length, StorageFormats.toRowMajor(matrix));
    }

    public static void transpose(Matrix2DFloat matrix) {
        if (matrix.COLUMNS == matrix.ROWS) {
            for (int i = 0; i < matrix.ROWS; ++i) {
                for (int j = 0; j < i; ++j) {
                    float tmp = matrix.get(i, j);
                    matrix.set(i, j, matrix.get(j, i));
                    matrix.set(j, i, tmp);
                }
            }
        }
    }

    public static void scale(Matrix2DFloat matrix, float value) {
        for (int i = 0; i < matrix.storage.getSize(); ++i) {
            matrix.storage.set(i, matrix.storage.get(i) * value);
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    public float get(int i, int j) {
        return this.storage.get(StorageFormats.toRowMajor(i, j, this.COLUMNS));
    }

    public void set(int i, int j, float value) {
        this.storage.set(StorageFormats.toRowMajor(i, j, this.COLUMNS), value);
    }

    public VectorFloat row(int row) {
        int baseIndex = StorageFormats.toRowMajor(row, 0, this.COLUMNS);
        int to = this.getFinalIndexOfRange(baseIndex);
        int size = to - baseIndex;
        FloatArray f = new FloatArray(size);
        int j = 0;
        for (int i = baseIndex; i < to; ++i) {
            f.set(j, this.storage.get(i));
            ++j;
        }
        return new VectorFloat(this.COLUMNS, f);
    }

    public VectorFloat column(int col) {
        int index = StorageFormats.toRowMajor(0, col, this.COLUMNS);
        VectorFloat vector = new VectorFloat(this.ROWS);
        for (int i = 0; i < this.ROWS; ++i) {
            vector.set(i, this.storage.get(index + i * this.COLUMNS));
        }
        return vector;
    }

    public VectorFloat diag() {
        VectorFloat v = new VectorFloat(Math.min(this.ROWS, this.COLUMNS));
        for (int i = 0; i < this.ROWS; ++i) {
            v.set(i, this.storage.get(i * (this.COLUMNS + 1)));
        }
        return v;
    }

    public void fill(float value) {
        this.storage.init(value);
    }

    public void multiply(Matrix2DFloat a, Matrix2DFloat b) {
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumColumns(); ++col) {
                float sum = 0.0f;
                for (int k = 0; k < b.getNumRows(); ++k) {
                    sum += a.get(row, k) * b.get(k, col);
                }
                this.set(row, col, sum);
            }
        }
    }

    public Matrix2DFloat duplicate() {
        Matrix2DFloat matrix = new Matrix2DFloat(this.ROWS, this.COLUMNS);
        matrix.set(this);
        return matrix;
    }

    public void set(Matrix2DFloat m) {
        for (int i = 0; i < m.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < this.ROWS; ++i) {
            for (int j = 0; j < this.COLUMNS; ++j) {
                str.append(String.format(fmt, Float.valueOf(this.get(i, j))) + " ");
            }
            str.append("\n");
        }
        return str.toString().trim();
    }

    public String toString() {
        Object result = String.format("MatrixFloat <%d x %d>", this.ROWS, this.COLUMNS);
        if (this.ROWS < 16 && this.COLUMNS < 16) {
            result = (String)result + "\n" + this.toString("%.3f");
        }
        return result;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.storage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.storage.getSegmentWithHeader();
    }
}

