/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.images;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.images.TornadoImagesInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;
import uk.ac.manchester.tornado.api.types.vectors.Byte3;

public final class ImageByte3
implements TornadoImagesInterface<ByteBuffer> {
    public static final Class<ImageByte3> TYPE = ImageByte3.class;
    private static final int elementSize = 3;
    private final ByteArray storage;
    private final int Y;
    private final int X;
    private final int numElements;

    public ImageByte3(int width, int height, ByteArray array) {
        this.storage = array;
        this.X = width;
        this.Y = height;
        this.numElements = this.X * this.Y * 3;
    }

    public ImageByte3(int width, int height) {
        this(width, height, new ByteArray(width * height * 3));
    }

    public ImageByte3(byte[][] matrix) {
        this(matrix.length / 3, matrix[0].length / 3, StorageFormats.toRowMajor(matrix));
    }

    public ByteArray getArray() {
        return this.storage;
    }

    private int getIndex(int x, int y) {
        return x * 3 + y * 3 * this.X;
    }

    public Byte3 get(int x) {
        return this.get(x, 0);
    }

    public void set(int x, Byte3 value) {
        this.set(x, 0, value);
    }

    public Byte3 get(int x, int y) {
        int offset = this.getIndex(x, y);
        return this.loadFromArray(this.storage, offset);
    }

    private Byte3 loadFromArray(ByteArray array, int index) {
        Byte3 result = new Byte3();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        return result;
    }

    public void set(int x, int y, Byte3 value) {
        int offset = this.getIndex(x, y);
        this.storeToArray(value, this.storage, offset);
    }

    private void storeToArray(Byte3 value, ByteArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
    }

    public int X() {
        return this.X;
    }

    public int Y() {
        return this.Y;
    }

    public void fill(byte value) {
        this.storage.init(value);
    }

    public ImageByte3 duplicate() {
        ImageByte3 image = new ImageByte3(this.X, this.Y);
        image.set(this);
        return image;
    }

    public void set(ImageByte3 m) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.Y; ++i) {
            for (int j = 0; j < this.X; ++j) {
                str.append(this.get(j, i).toString(fmt)).append("\n");
            }
        }
        return str.toString();
    }

    public String toString() {
        Object result = String.format("ImageByte3 <%d x %d>", this.X, this.Y);
        if (this.X <= 8 && this.Y <= 8) {
            result = (String)result + "\n" + this.toString("{%3d,%3d,%3d}");
        }
        return result;
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ByteBuffer asBuffer() {
        return ByteBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

