/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Int3;

public final class VectorInt3
implements TornadoCollectionInterface<IntBuffer> {
    public static final Class<VectorInt3> TYPE = VectorInt3.class;
    private static final int ELEMENT_SIZE = 3;
    protected final IntArray storage;
    private final int numElements;

    VectorInt3(int numElements, IntArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorInt3(IntArray array) {
        this(array.getSize() / 3, array);
    }

    public VectorInt3(int numElements) {
        this(numElements, new IntArray(numElements * 3));
    }

    public int vectorWidth() {
        return 3;
    }

    private int toIndex(int index) {
        return index * 3;
    }

    public Int3 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Int3 loadFromArray(IntArray array, int index) {
        Int3 result = new Int3();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        return result;
    }

    public void set(int index, Int3 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Int3 value, IntArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
    }

    public void set(VectorInt3 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(IntArray values) {
        VectorInt3 vector = new VectorInt3(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(int value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorInt3 duplicate() {
        VectorInt3 vector = new VectorInt3(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 3) {
            return String.format("VectorInt3 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Int3 sum() {
        Int3 result = new Int3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int3.add(result, this.get(i));
        }
        return result;
    }

    public Int3 min() {
        Int3 result = new Int3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int3.min(result, this.get(i));
        }
        return result;
    }

    public Int3 max() {
        Int3 result = new Int3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int3.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public IntArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

