/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Float2;

public final class VectorFloat2
implements TornadoCollectionInterface<FloatBuffer> {
    public static final Class<VectorFloat2> TYPE = VectorFloat2.class;
    private static final int ELEMENT_SIZE = 2;
    private final FloatArray storage;
    private final int numElements;

    VectorFloat2(int numElements, FloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorFloat2(int numElements) {
        this(numElements, new FloatArray(numElements * 2));
    }

    private VectorFloat2(FloatArray array) {
        this(array.getSize() / 2, array);
    }

    public int vectorWidth() {
        return 2;
    }

    private int toIndex(int index) {
        return index * 2;
    }

    public Float2 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Float2 loadFromArray(FloatArray array, int index) {
        Float2 result = new Float2();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        return result;
    }

    public void set(int index, Float2 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Float2 value, FloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
    }

    public void set(VectorFloat2 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(FloatArray values) {
        VectorFloat2 vector = new VectorFloat2(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(float value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorFloat2 duplicate() {
        VectorFloat2 vector = new VectorFloat2(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 2) {
            return String.format("VectorFloat2 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Float2 sum() {
        Float2 result = new Float2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float2.add(result, this.get(i));
        }
        return result;
    }

    public Float2 min() {
        Float2 result = new Float2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float2.min(result, this.get(i));
        }
        return result;
    }

    public Float2 max() {
        Float2 result = new Float2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float2.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public FloatArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

