/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Float16;

public final class VectorFloat16
implements TornadoCollectionInterface<FloatBuffer> {
    public static final Class<VectorFloat16> TYPE = VectorFloat16.class;
    private static final int ELEMENT_SIZE = 16;
    private final FloatArray storage;
    private final int numElements;

    VectorFloat16(int numElements, FloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorFloat16(FloatArray array) {
        this(array.getSize() / 16, array);
    }

    public VectorFloat16(int numElements) {
        this(numElements, new FloatArray(numElements * 16));
    }

    private int toIndex(int index) {
        return index * 16;
    }

    public Float16 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Float16 loadFromArray(FloatArray array, int index) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, array.get(index + i));
        }
        return result;
    }

    public void set(int index, Float16 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Float16 value, FloatArray array, int index) {
        for (int i = 0; i < 16; ++i) {
            array.set(index + i, value.get(i));
        }
    }

    public void set(VectorFloat16 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(FloatArray values) {
        VectorFloat16 vector = new VectorFloat16(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(float value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorFloat16 duplicate() {
        VectorFloat16 vector = new VectorFloat16(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 16) {
            return String.format("VectorFloat16 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Float16 sum() {
        Float16 result = new Float16();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float16.add(result, this.get(i));
        }
        return result;
    }

    public Float16 min() {
        Float16 result = new Float16();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float16.min(result, this.get(i));
        }
        return result;
    }

    public Float16 max() {
        Float16 result = new Float16();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float16.max(result, this.get(i));
        }
        return result;
    }

    public int vectorWidth() {
        return 16;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public FloatArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

